/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PropagatedRouteTable;
import com.azure.resourcemanager.network.models.VnetRoute;
import java.io.IOException;

public final class RoutingConfiguration
implements JsonSerializable<RoutingConfiguration> {
    private SubResource associatedRouteTable;
    private PropagatedRouteTable propagatedRouteTables;
    private VnetRoute vnetRoutes;
    private SubResource inboundRouteMap;
    private SubResource outboundRouteMap;

    public SubResource associatedRouteTable() {
        return this.associatedRouteTable;
    }

    public RoutingConfiguration withAssociatedRouteTable(SubResource associatedRouteTable) {
        this.associatedRouteTable = associatedRouteTable;
        return this;
    }

    public PropagatedRouteTable propagatedRouteTables() {
        return this.propagatedRouteTables;
    }

    public RoutingConfiguration withPropagatedRouteTables(PropagatedRouteTable propagatedRouteTables) {
        this.propagatedRouteTables = propagatedRouteTables;
        return this;
    }

    public VnetRoute vnetRoutes() {
        return this.vnetRoutes;
    }

    public RoutingConfiguration withVnetRoutes(VnetRoute vnetRoutes) {
        this.vnetRoutes = vnetRoutes;
        return this;
    }

    public SubResource inboundRouteMap() {
        return this.inboundRouteMap;
    }

    public RoutingConfiguration withInboundRouteMap(SubResource inboundRouteMap) {
        this.inboundRouteMap = inboundRouteMap;
        return this;
    }

    public SubResource outboundRouteMap() {
        return this.outboundRouteMap;
    }

    public RoutingConfiguration withOutboundRouteMap(SubResource outboundRouteMap) {
        this.outboundRouteMap = outboundRouteMap;
        return this;
    }

    public void validate() {
        if (this.propagatedRouteTables() != null) {
            this.propagatedRouteTables().validate();
        }
        if (this.vnetRoutes() != null) {
            this.vnetRoutes().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("associatedRouteTable", (JsonSerializable)this.associatedRouteTable);
        jsonWriter.writeJsonField("propagatedRouteTables", (JsonSerializable)this.propagatedRouteTables);
        jsonWriter.writeJsonField("vnetRoutes", (JsonSerializable)this.vnetRoutes);
        jsonWriter.writeJsonField("inboundRouteMap", (JsonSerializable)this.inboundRouteMap);
        jsonWriter.writeJsonField("outboundRouteMap", (JsonSerializable)this.outboundRouteMap);
        return jsonWriter.writeEndObject();
    }

    public static RoutingConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingConfiguration)jsonReader.readObject(reader -> {
            RoutingConfiguration deserializedRoutingConfiguration = new RoutingConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedRouteTable".equals(fieldName)) {
                    deserializedRoutingConfiguration.associatedRouteTable = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("propagatedRouteTables".equals(fieldName)) {
                    deserializedRoutingConfiguration.propagatedRouteTables = PropagatedRouteTable.fromJson(reader);
                    continue;
                }
                if ("vnetRoutes".equals(fieldName)) {
                    deserializedRoutingConfiguration.vnetRoutes = VnetRoute.fromJson(reader);
                    continue;
                }
                if ("inboundRouteMap".equals(fieldName)) {
                    deserializedRoutingConfiguration.inboundRouteMap = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("outboundRouteMap".equals(fieldName)) {
                    deserializedRoutingConfiguration.outboundRouteMap = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingConfiguration;
        });
    }
}

