/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayNatRuleInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.AdminState;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ResiliencyModel;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayAutoScaleConfiguration;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayPolicyGroup;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewaySku;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayType;
import com.azure.resourcemanager.network.models.VpnClientConfiguration;
import com.azure.resourcemanager.network.models.VpnGatewayGeneration;
import com.azure.resourcemanager.network.models.VpnType;
import java.io.IOException;
import java.util.List;

public final class VirtualNetworkGatewayPropertiesFormat
implements JsonSerializable<VirtualNetworkGatewayPropertiesFormat> {
    private VirtualNetworkGatewayAutoScaleConfiguration autoScaleConfiguration;
    private List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations;
    private VirtualNetworkGatewayType gatewayType;
    private VpnType vpnType;
    private VpnGatewayGeneration vpnGatewayGeneration;
    private Boolean enableBgp;
    private Boolean enablePrivateIpAddress;
    private Boolean active;
    private Boolean disableIpSecReplayProtection;
    private SubResource gatewayDefaultSite;
    private VirtualNetworkGatewaySku sku;
    private VpnClientConfiguration vpnClientConfiguration;
    private List<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups;
    private BgpSettings bgpSettings;
    private AddressSpace customRoutes;
    private String resourceGuid;
    private ProvisioningState provisioningState;
    private Boolean enableDnsForwarding;
    private String inboundDnsForwardingEndpoint;
    private String vNetExtendedLocationResourceId;
    private List<VirtualNetworkGatewayNatRuleInner> natRules;
    private Boolean enableBgpRouteTranslationForNat;
    private Boolean allowVirtualWanTraffic;
    private Boolean allowRemoteVnetTraffic;
    private AdminState adminState;
    private ResiliencyModel resiliencyModel;

    public VirtualNetworkGatewayAutoScaleConfiguration autoScaleConfiguration() {
        return this.autoScaleConfiguration;
    }

    public VirtualNetworkGatewayPropertiesFormat withAutoScaleConfiguration(VirtualNetworkGatewayAutoScaleConfiguration autoScaleConfiguration) {
        this.autoScaleConfiguration = autoScaleConfiguration;
        return this;
    }

    public List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualNetworkGatewayPropertiesFormat withIpConfigurations(List<VirtualNetworkGatewayIpConfigurationInner> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public VirtualNetworkGatewayType gatewayType() {
        return this.gatewayType;
    }

    public VirtualNetworkGatewayPropertiesFormat withGatewayType(VirtualNetworkGatewayType gatewayType) {
        this.gatewayType = gatewayType;
        return this;
    }

    public VpnType vpnType() {
        return this.vpnType;
    }

    public VirtualNetworkGatewayPropertiesFormat withVpnType(VpnType vpnType) {
        this.vpnType = vpnType;
        return this;
    }

    public VpnGatewayGeneration vpnGatewayGeneration() {
        return this.vpnGatewayGeneration;
    }

    public VirtualNetworkGatewayPropertiesFormat withVpnGatewayGeneration(VpnGatewayGeneration vpnGatewayGeneration) {
        this.vpnGatewayGeneration = vpnGatewayGeneration;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayPropertiesFormat withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean enablePrivateIpAddress() {
        return this.enablePrivateIpAddress;
    }

    public VirtualNetworkGatewayPropertiesFormat withEnablePrivateIpAddress(Boolean enablePrivateIpAddress) {
        this.enablePrivateIpAddress = enablePrivateIpAddress;
        return this;
    }

    public Boolean active() {
        return this.active;
    }

    public VirtualNetworkGatewayPropertiesFormat withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public Boolean disableIpSecReplayProtection() {
        return this.disableIpSecReplayProtection;
    }

    public VirtualNetworkGatewayPropertiesFormat withDisableIpSecReplayProtection(Boolean disableIpSecReplayProtection) {
        this.disableIpSecReplayProtection = disableIpSecReplayProtection;
        return this;
    }

    public SubResource gatewayDefaultSite() {
        return this.gatewayDefaultSite;
    }

    public VirtualNetworkGatewayPropertiesFormat withGatewayDefaultSite(SubResource gatewayDefaultSite) {
        this.gatewayDefaultSite = gatewayDefaultSite;
        return this;
    }

    public VirtualNetworkGatewaySku sku() {
        return this.sku;
    }

    public VirtualNetworkGatewayPropertiesFormat withSku(VirtualNetworkGatewaySku sku) {
        this.sku = sku;
        return this;
    }

    public VpnClientConfiguration vpnClientConfiguration() {
        return this.vpnClientConfiguration;
    }

    public VirtualNetworkGatewayPropertiesFormat withVpnClientConfiguration(VpnClientConfiguration vpnClientConfiguration) {
        this.vpnClientConfiguration = vpnClientConfiguration;
        return this;
    }

    public List<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups() {
        return this.virtualNetworkGatewayPolicyGroups;
    }

    public VirtualNetworkGatewayPropertiesFormat withVirtualNetworkGatewayPolicyGroups(List<VirtualNetworkGatewayPolicyGroup> virtualNetworkGatewayPolicyGroups) {
        this.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups;
        return this;
    }

    public BgpSettings bgpSettings() {
        return this.bgpSettings;
    }

    public VirtualNetworkGatewayPropertiesFormat withBgpSettings(BgpSettings bgpSettings) {
        this.bgpSettings = bgpSettings;
        return this;
    }

    public AddressSpace customRoutes() {
        return this.customRoutes;
    }

    public VirtualNetworkGatewayPropertiesFormat withCustomRoutes(AddressSpace customRoutes) {
        this.customRoutes = customRoutes;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean enableDnsForwarding() {
        return this.enableDnsForwarding;
    }

    public VirtualNetworkGatewayPropertiesFormat withEnableDnsForwarding(Boolean enableDnsForwarding) {
        this.enableDnsForwarding = enableDnsForwarding;
        return this;
    }

    public String inboundDnsForwardingEndpoint() {
        return this.inboundDnsForwardingEndpoint;
    }

    public String vNetExtendedLocationResourceId() {
        return this.vNetExtendedLocationResourceId;
    }

    public VirtualNetworkGatewayPropertiesFormat withVNetExtendedLocationResourceId(String vNetExtendedLocationResourceId) {
        this.vNetExtendedLocationResourceId = vNetExtendedLocationResourceId;
        return this;
    }

    public List<VirtualNetworkGatewayNatRuleInner> natRules() {
        return this.natRules;
    }

    public VirtualNetworkGatewayPropertiesFormat withNatRules(List<VirtualNetworkGatewayNatRuleInner> natRules) {
        this.natRules = natRules;
        return this;
    }

    public Boolean enableBgpRouteTranslationForNat() {
        return this.enableBgpRouteTranslationForNat;
    }

    public VirtualNetworkGatewayPropertiesFormat withEnableBgpRouteTranslationForNat(Boolean enableBgpRouteTranslationForNat) {
        this.enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat;
        return this;
    }

    public Boolean allowVirtualWanTraffic() {
        return this.allowVirtualWanTraffic;
    }

    public VirtualNetworkGatewayPropertiesFormat withAllowVirtualWanTraffic(Boolean allowVirtualWanTraffic) {
        this.allowVirtualWanTraffic = allowVirtualWanTraffic;
        return this;
    }

    public Boolean allowRemoteVnetTraffic() {
        return this.allowRemoteVnetTraffic;
    }

    public VirtualNetworkGatewayPropertiesFormat withAllowRemoteVnetTraffic(Boolean allowRemoteVnetTraffic) {
        this.allowRemoteVnetTraffic = allowRemoteVnetTraffic;
        return this;
    }

    public AdminState adminState() {
        return this.adminState;
    }

    public VirtualNetworkGatewayPropertiesFormat withAdminState(AdminState adminState) {
        this.adminState = adminState;
        return this;
    }

    public ResiliencyModel resiliencyModel() {
        return this.resiliencyModel;
    }

    public VirtualNetworkGatewayPropertiesFormat withResiliencyModel(ResiliencyModel resiliencyModel) {
        this.resiliencyModel = resiliencyModel;
        return this;
    }

    public void validate() {
        if (this.autoScaleConfiguration() != null) {
            this.autoScaleConfiguration().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.vpnClientConfiguration() != null) {
            this.vpnClientConfiguration().validate();
        }
        if (this.virtualNetworkGatewayPolicyGroups() != null) {
            this.virtualNetworkGatewayPolicyGroups().forEach(e -> e.validate());
        }
        if (this.bgpSettings() != null) {
            this.bgpSettings().validate();
        }
        if (this.customRoutes() != null) {
            this.customRoutes().validate();
        }
        if (this.natRules() != null) {
            this.natRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("autoScaleConfiguration", (JsonSerializable)this.autoScaleConfiguration);
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("gatewayType", this.gatewayType == null ? null : this.gatewayType.toString());
        jsonWriter.writeStringField("vpnType", this.vpnType == null ? null : this.vpnType.toString());
        jsonWriter.writeStringField("vpnGatewayGeneration", this.vpnGatewayGeneration == null ? null : this.vpnGatewayGeneration.toString());
        jsonWriter.writeBooleanField("enableBgp", this.enableBgp);
        jsonWriter.writeBooleanField("enablePrivateIpAddress", this.enablePrivateIpAddress);
        jsonWriter.writeBooleanField("activeActive", this.active);
        jsonWriter.writeBooleanField("disableIPSecReplayProtection", this.disableIpSecReplayProtection);
        jsonWriter.writeJsonField("gatewayDefaultSite", (JsonSerializable)this.gatewayDefaultSite);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("vpnClientConfiguration", (JsonSerializable)this.vpnClientConfiguration);
        jsonWriter.writeArrayField("virtualNetworkGatewayPolicyGroups", this.virtualNetworkGatewayPolicyGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("bgpSettings", (JsonSerializable)this.bgpSettings);
        jsonWriter.writeJsonField("customRoutes", (JsonSerializable)this.customRoutes);
        jsonWriter.writeBooleanField("enableDnsForwarding", this.enableDnsForwarding);
        jsonWriter.writeStringField("vNetExtendedLocationResourceId", this.vNetExtendedLocationResourceId);
        jsonWriter.writeArrayField("natRules", this.natRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableBgpRouteTranslationForNat", this.enableBgpRouteTranslationForNat);
        jsonWriter.writeBooleanField("allowVirtualWanTraffic", this.allowVirtualWanTraffic);
        jsonWriter.writeBooleanField("allowRemoteVnetTraffic", this.allowRemoteVnetTraffic);
        jsonWriter.writeStringField("adminState", this.adminState == null ? null : this.adminState.toString());
        jsonWriter.writeStringField("resiliencyModel", this.resiliencyModel == null ? null : this.resiliencyModel.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkGatewayPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkGatewayPropertiesFormat)jsonReader.readObject(reader -> {
            VirtualNetworkGatewayPropertiesFormat deserializedVirtualNetworkGatewayPropertiesFormat = new VirtualNetworkGatewayPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoScaleConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.autoScaleConfiguration = VirtualNetworkGatewayAutoScaleConfiguration.fromJson(reader);
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedVirtualNetworkGatewayPropertiesFormat.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> VirtualNetworkGatewayIpConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("gatewayType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.gatewayType = VirtualNetworkGatewayType.fromString(reader.getString());
                    continue;
                }
                if ("vpnType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.vpnType = VpnType.fromString(reader.getString());
                    continue;
                }
                if ("vpnGatewayGeneration".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.vpnGatewayGeneration = VpnGatewayGeneration.fromString(reader.getString());
                    continue;
                }
                if ("enableBgp".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.enableBgp = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enablePrivateIpAddress".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.enablePrivateIpAddress = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("activeActive".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.active = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableIPSecReplayProtection".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.disableIpSecReplayProtection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gatewayDefaultSite".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.gatewayDefaultSite = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.sku = VirtualNetworkGatewaySku.fromJson(reader);
                    continue;
                }
                if ("vpnClientConfiguration".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.vpnClientConfiguration = VpnClientConfiguration.fromJson(reader);
                    continue;
                }
                if ("virtualNetworkGatewayPolicyGroups".equals(fieldName)) {
                    List virtualNetworkGatewayPolicyGroups;
                    deserializedVirtualNetworkGatewayPropertiesFormat.virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups = reader.readArray(reader1 -> VirtualNetworkGatewayPolicyGroup.fromJson(reader1));
                    continue;
                }
                if ("bgpSettings".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.bgpSettings = BgpSettings.fromJson(reader);
                    continue;
                }
                if ("customRoutes".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.customRoutes = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("enableDnsForwarding".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.enableDnsForwarding = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("inboundDnsForwardingEndpoint".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.inboundDnsForwardingEndpoint = reader.getString();
                    continue;
                }
                if ("vNetExtendedLocationResourceId".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.vNetExtendedLocationResourceId = reader.getString();
                    continue;
                }
                if ("natRules".equals(fieldName)) {
                    List natRules;
                    deserializedVirtualNetworkGatewayPropertiesFormat.natRules = natRules = reader.readArray(reader1 -> VirtualNetworkGatewayNatRuleInner.fromJson(reader1));
                    continue;
                }
                if ("enableBgpRouteTranslationForNat".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.enableBgpRouteTranslationForNat = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowVirtualWanTraffic".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.allowVirtualWanTraffic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowRemoteVnetTraffic".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.allowRemoteVnetTraffic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("adminState".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.adminState = AdminState.fromString(reader.getString());
                    continue;
                }
                if ("resiliencyModel".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayPropertiesFormat.resiliencyModel = ResiliencyModel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkGatewayPropertiesFormat;
        });
    }
}

