/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationProfileInner;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.RouteTableInner;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyInner;
import com.azure.resourcemanager.network.fluent.models.SubnetPropertiesFormatInner;
import com.azure.resourcemanager.network.models.Delegation;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ResourceNavigationLink;
import com.azure.resourcemanager.network.models.ServiceAssociationLink;
import com.azure.resourcemanager.network.models.ServiceEndpointPropertiesFormat;
import com.azure.resourcemanager.network.models.SharingScope;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateEndpointNetworkPolicies;
import com.azure.resourcemanager.network.models.VirtualNetworkPrivateLinkServiceNetworkPolicies;
import java.io.IOException;
import java.util.List;

public final class SubnetInner
extends SubResource {
    private SubnetPropertiesFormatInner innerProperties;
    private String name;
    private String etag;
    private String type;

    private SubnetPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public SubnetInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public SubnetInner withType(String type) {
        this.type = type;
        return this;
    }

    public SubnetInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public SubnetInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public List<String> addressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefixes();
    }

    public SubnetInner withAddressPrefixes(List<String> addressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withAddressPrefixes(addressPrefixes);
        return this;
    }

    public NetworkSecurityGroupInner networkSecurityGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSecurityGroup();
    }

    public SubnetInner withNetworkSecurityGroup(NetworkSecurityGroupInner networkSecurityGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withNetworkSecurityGroup(networkSecurityGroup);
        return this;
    }

    public RouteTableInner routeTable() {
        return this.innerProperties() == null ? null : this.innerProperties().routeTable();
    }

    public SubnetInner withRouteTable(RouteTableInner routeTable) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withRouteTable(routeTable);
        return this;
    }

    public SubResource natGateway() {
        return this.innerProperties() == null ? null : this.innerProperties().natGateway();
    }

    public SubnetInner withNatGateway(SubResource natGateway) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withNatGateway(natGateway);
        return this;
    }

    public List<ServiceEndpointPropertiesFormat> serviceEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceEndpoints();
    }

    public SubnetInner withServiceEndpoints(List<ServiceEndpointPropertiesFormat> serviceEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withServiceEndpoints(serviceEndpoints);
        return this;
    }

    public List<ServiceEndpointPolicyInner> serviceEndpointPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceEndpointPolicies();
    }

    public SubnetInner withServiceEndpointPolicies(List<ServiceEndpointPolicyInner> serviceEndpointPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withServiceEndpointPolicies(serviceEndpointPolicies);
        return this;
    }

    public List<PrivateEndpointInner> privateEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoints();
    }

    public List<IpConfigurationInner> ipConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurations();
    }

    public List<IpConfigurationProfileInner> ipConfigurationProfiles() {
        return this.innerProperties() == null ? null : this.innerProperties().ipConfigurationProfiles();
    }

    public List<SubResource> ipAllocations() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAllocations();
    }

    public SubnetInner withIpAllocations(List<SubResource> ipAllocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withIpAllocations(ipAllocations);
        return this;
    }

    public List<ResourceNavigationLink> resourceNavigationLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceNavigationLinks();
    }

    public List<ServiceAssociationLink> serviceAssociationLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceAssociationLinks();
    }

    public List<Delegation> delegations() {
        return this.innerProperties() == null ? null : this.innerProperties().delegations();
    }

    public SubnetInner withDelegations(List<Delegation> delegations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withDelegations(delegations);
        return this;
    }

    public String purpose() {
        return this.innerProperties() == null ? null : this.innerProperties().purpose();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointNetworkPolicies();
    }

    public SubnetInner withPrivateEndpointNetworkPolicies(VirtualNetworkPrivateEndpointNetworkPolicies privateEndpointNetworkPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withPrivateEndpointNetworkPolicies(privateEndpointNetworkPolicies);
        return this;
    }

    public VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceNetworkPolicies();
    }

    public SubnetInner withPrivateLinkServiceNetworkPolicies(VirtualNetworkPrivateLinkServiceNetworkPolicies privateLinkServiceNetworkPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withPrivateLinkServiceNetworkPolicies(privateLinkServiceNetworkPolicies);
        return this;
    }

    public List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationGatewayIpConfigurations();
    }

    public SubnetInner withApplicationGatewayIpConfigurations(List<ApplicationGatewayIpConfigurationInner> applicationGatewayIpConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withApplicationGatewayIpConfigurations(applicationGatewayIpConfigurations);
        return this;
    }

    public SharingScope sharingScope() {
        return this.innerProperties() == null ? null : this.innerProperties().sharingScope();
    }

    public SubnetInner withSharingScope(SharingScope sharingScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withSharingScope(sharingScope);
        return this;
    }

    public Boolean defaultOutboundAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultOutboundAccess();
    }

    public SubnetInner withDefaultOutboundAccess(Boolean defaultOutboundAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SubnetPropertiesFormatInner();
        }
        this.innerProperties().withDefaultOutboundAccess(defaultOutboundAccess);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static SubnetInner fromJson(JsonReader jsonReader) throws IOException {
        return (SubnetInner)((Object)jsonReader.readObject(reader -> {
            SubnetInner deserializedSubnetInner = new SubnetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSubnetInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSubnetInner.innerProperties = SubnetPropertiesFormatInner.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSubnetInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSubnetInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSubnetInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubnetInner;
        }));
    }
}

