// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Recommended actions based on discovered issues.
 */
@Fluent
public final class TroubleshootingRecommendedActions implements JsonSerializable<TroubleshootingRecommendedActions> {
    /*
     * ID of the recommended action.
     */
    private String actionId;

    /*
     * Description of recommended actions.
     */
    private String actionText;

    /*
     * The uri linking to a documentation for the recommended troubleshooting actions.
     */
    private String actionUri;

    /*
     * The information from the URI for the recommended troubleshooting actions.
     */
    private String actionUriText;

    /**
     * Creates an instance of TroubleshootingRecommendedActions class.
     */
    public TroubleshootingRecommendedActions() {
    }

    /**
     * Get the actionId property: ID of the recommended action.
     * 
     * @return the actionId value.
     */
    public String actionId() {
        return this.actionId;
    }

    /**
     * Set the actionId property: ID of the recommended action.
     * 
     * @param actionId the actionId value to set.
     * @return the TroubleshootingRecommendedActions object itself.
     */
    public TroubleshootingRecommendedActions withActionId(String actionId) {
        this.actionId = actionId;
        return this;
    }

    /**
     * Get the actionText property: Description of recommended actions.
     * 
     * @return the actionText value.
     */
    public String actionText() {
        return this.actionText;
    }

    /**
     * Set the actionText property: Description of recommended actions.
     * 
     * @param actionText the actionText value to set.
     * @return the TroubleshootingRecommendedActions object itself.
     */
    public TroubleshootingRecommendedActions withActionText(String actionText) {
        this.actionText = actionText;
        return this;
    }

    /**
     * Get the actionUri property: The uri linking to a documentation for the recommended troubleshooting actions.
     * 
     * @return the actionUri value.
     */
    public String actionUri() {
        return this.actionUri;
    }

    /**
     * Set the actionUri property: The uri linking to a documentation for the recommended troubleshooting actions.
     * 
     * @param actionUri the actionUri value to set.
     * @return the TroubleshootingRecommendedActions object itself.
     */
    public TroubleshootingRecommendedActions withActionUri(String actionUri) {
        this.actionUri = actionUri;
        return this;
    }

    /**
     * Get the actionUriText property: The information from the URI for the recommended troubleshooting actions.
     * 
     * @return the actionUriText value.
     */
    public String actionUriText() {
        return this.actionUriText;
    }

    /**
     * Set the actionUriText property: The information from the URI for the recommended troubleshooting actions.
     * 
     * @param actionUriText the actionUriText value to set.
     * @return the TroubleshootingRecommendedActions object itself.
     */
    public TroubleshootingRecommendedActions withActionUriText(String actionUriText) {
        this.actionUriText = actionUriText;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionId", this.actionId);
        jsonWriter.writeStringField("actionText", this.actionText);
        jsonWriter.writeStringField("actionUri", this.actionUri);
        jsonWriter.writeStringField("actionUriText", this.actionUriText);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TroubleshootingRecommendedActions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TroubleshootingRecommendedActions if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the TroubleshootingRecommendedActions.
     */
    public static TroubleshootingRecommendedActions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TroubleshootingRecommendedActions deserializedTroubleshootingRecommendedActions
                = new TroubleshootingRecommendedActions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionId".equals(fieldName)) {
                    deserializedTroubleshootingRecommendedActions.actionId = reader.getString();
                } else if ("actionText".equals(fieldName)) {
                    deserializedTroubleshootingRecommendedActions.actionText = reader.getString();
                } else if ("actionUri".equals(fieldName)) {
                    deserializedTroubleshootingRecommendedActions.actionUri = reader.getString();
                } else if ("actionUriText".equals(fieldName)) {
                    deserializedTroubleshootingRecommendedActions.actionUriText = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTroubleshootingRecommendedActions;
        });
    }
}
