// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The network resource topology information for the given resource group.
 */
@Fluent
public final class TopologyResource implements JsonSerializable<TopologyResource> {
    /*
     * Name of the resource.
     */
    private String name;

    /*
     * ID of the resource.
     */
    private String id;

    /*
     * Resource location.
     */
    private String location;

    /*
     * Holds the associations the resource has with other resources in the resource group.
     */
    private List<TopologyAssociation> associations;

    /**
     * Creates an instance of TopologyResource class.
     */
    public TopologyResource() {
    }

    /**
     * Get the name property: Name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the resource.
     * 
     * @param name the name value to set.
     * @return the TopologyResource object itself.
     */
    public TopologyResource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: ID of the resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: ID of the resource.
     * 
     * @param id the id value to set.
     * @return the TopologyResource object itself.
     */
    public TopologyResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the location property: Resource location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Resource location.
     * 
     * @param location the location value to set.
     * @return the TopologyResource object itself.
     */
    public TopologyResource withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the associations property: Holds the associations the resource has with other resources in the resource
     * group.
     * 
     * @return the associations value.
     */
    public List<TopologyAssociation> associations() {
        return this.associations;
    }

    /**
     * Set the associations property: Holds the associations the resource has with other resources in the resource
     * group.
     * 
     * @param associations the associations value to set.
     * @return the TopologyResource object itself.
     */
    public TopologyResource withAssociations(List<TopologyAssociation> associations) {
        this.associations = associations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (associations() != null) {
            associations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeArrayField("associations", this.associations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TopologyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TopologyResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TopologyResource.
     */
    public static TopologyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TopologyResource deserializedTopologyResource = new TopologyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedTopologyResource.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedTopologyResource.id = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedTopologyResource.location = reader.getString();
                } else if ("associations".equals(fieldName)) {
                    List<TopologyAssociation> associations
                        = reader.readArray(reader1 -> TopologyAssociation.fromJson(reader1));
                    deserializedTopologyResource.associations = associations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTopologyResource;
        });
    }
}
