// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SingleQueryResult model.
 */
@Fluent
public final class SingleQueryResult implements JsonSerializable<SingleQueryResult> {
    /*
     * The ID of the signature
     */
    private Integer signatureId;

    /*
     * The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny
     */
    private FirewallPolicyIdpsSignatureMode mode;

    /*
     * Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low
     */
    private FirewallPolicyIdpsSignatureSeverity severity;

    /*
     * Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound, 2 - Any, 3 - Internal, 4 -
     * InternalOutbound
     */
    private FirewallPolicyIdpsSignatureDirection direction;

    /*
     * Describes the groups the signature belongs to
     */
    private String group;

    /*
     * Describes what is the signature enforces
     */
    private String description;

    /*
     * Describes the protocol the signatures is being enforced in
     */
    private String protocol;

    /*
     * Describes the list of source ports related to this signature
     */
    private List<String> sourcePorts;

    /*
     * Describes the list of destination ports related to this signature
     */
    private List<String> destinationPorts;

    /*
     * Describes the last updated time of the signature (provided from 3rd party vendor)
     */
    private String lastUpdated;

    /*
     * Describes if this override is inherited from base policy or not
     */
    private Boolean inheritedFromParentPolicy;

    /**
     * Creates an instance of SingleQueryResult class.
     */
    public SingleQueryResult() {
    }

    /**
     * Get the signatureId property: The ID of the signature.
     * 
     * @return the signatureId value.
     */
    public Integer signatureId() {
        return this.signatureId;
    }

    /**
     * Set the signatureId property: The ID of the signature.
     * 
     * @param signatureId the signatureId value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withSignatureId(Integer signatureId) {
        this.signatureId = signatureId;
        return this;
    }

    /**
     * Get the mode property: The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny.
     * 
     * @return the mode value.
     */
    public FirewallPolicyIdpsSignatureMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The current mode enforced, 0 - Disabled, 1 - Alert, 2 -Deny.
     * 
     * @param mode the mode value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withMode(FirewallPolicyIdpsSignatureMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the severity property: Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low.
     * 
     * @return the severity value.
     */
    public FirewallPolicyIdpsSignatureSeverity severity() {
        return this.severity;
    }

    /**
     * Set the severity property: Describes the severity of signature: 1 - High, 2 - Medium, 3 - Low.
     * 
     * @param severity the severity value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withSeverity(FirewallPolicyIdpsSignatureSeverity severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the direction property: Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound,
     * 2 - Any, 3 - Internal, 4 - InternalOutbound.
     * 
     * @return the direction value.
     */
    public FirewallPolicyIdpsSignatureDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: Describes in which direction signature is being enforced: 0 - OutBound, 1 - InBound,
     * 2 - Any, 3 - Internal, 4 - InternalOutbound.
     * 
     * @param direction the direction value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withDirection(FirewallPolicyIdpsSignatureDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the group property: Describes the groups the signature belongs to.
     * 
     * @return the group value.
     */
    public String group() {
        return this.group;
    }

    /**
     * Set the group property: Describes the groups the signature belongs to.
     * 
     * @param group the group value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withGroup(String group) {
        this.group = group;
        return this;
    }

    /**
     * Get the description property: Describes what is the signature enforces.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Describes what is the signature enforces.
     * 
     * @param description the description value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the protocol property: Describes the protocol the signatures is being enforced in.
     * 
     * @return the protocol value.
     */
    public String protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Describes the protocol the signatures is being enforced in.
     * 
     * @param protocol the protocol value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the sourcePorts property: Describes the list of source ports related to this signature.
     * 
     * @return the sourcePorts value.
     */
    public List<String> sourcePorts() {
        return this.sourcePorts;
    }

    /**
     * Set the sourcePorts property: Describes the list of source ports related to this signature.
     * 
     * @param sourcePorts the sourcePorts value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withSourcePorts(List<String> sourcePorts) {
        this.sourcePorts = sourcePorts;
        return this;
    }

    /**
     * Get the destinationPorts property: Describes the list of destination ports related to this signature.
     * 
     * @return the destinationPorts value.
     */
    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    /**
     * Set the destinationPorts property: Describes the list of destination ports related to this signature.
     * 
     * @param destinationPorts the destinationPorts value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    /**
     * Get the lastUpdated property: Describes the last updated time of the signature (provided from 3rd party vendor).
     * 
     * @return the lastUpdated value.
     */
    public String lastUpdated() {
        return this.lastUpdated;
    }

    /**
     * Set the lastUpdated property: Describes the last updated time of the signature (provided from 3rd party vendor).
     * 
     * @param lastUpdated the lastUpdated value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * Get the inheritedFromParentPolicy property: Describes if this override is inherited from base policy or not.
     * 
     * @return the inheritedFromParentPolicy value.
     */
    public Boolean inheritedFromParentPolicy() {
        return this.inheritedFromParentPolicy;
    }

    /**
     * Set the inheritedFromParentPolicy property: Describes if this override is inherited from base policy or not.
     * 
     * @param inheritedFromParentPolicy the inheritedFromParentPolicy value to set.
     * @return the SingleQueryResult object itself.
     */
    public SingleQueryResult withInheritedFromParentPolicy(Boolean inheritedFromParentPolicy) {
        this.inheritedFromParentPolicy = inheritedFromParentPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("signatureId", this.signatureId);
        jsonWriter.writeNumberField("mode", this.mode == null ? null : this.mode.toInt());
        jsonWriter.writeNumberField("severity", this.severity == null ? null : this.severity.toInt());
        jsonWriter.writeNumberField("direction", this.direction == null ? null : this.direction.toInt());
        jsonWriter.writeStringField("group", this.group);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("protocol", this.protocol);
        jsonWriter.writeArrayField("sourcePorts", this.sourcePorts, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("destinationPorts", this.destinationPorts,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("lastUpdated", this.lastUpdated);
        jsonWriter.writeBooleanField("inheritedFromParentPolicy", this.inheritedFromParentPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SingleQueryResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SingleQueryResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SingleQueryResult.
     */
    public static SingleQueryResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleQueryResult deserializedSingleQueryResult = new SingleQueryResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("signatureId".equals(fieldName)) {
                    deserializedSingleQueryResult.signatureId = reader.getNullable(JsonReader::getInt);
                } else if ("mode".equals(fieldName)) {
                    deserializedSingleQueryResult.mode = FirewallPolicyIdpsSignatureMode.fromInt(reader.getInt());
                } else if ("severity".equals(fieldName)) {
                    deserializedSingleQueryResult.severity
                        = FirewallPolicyIdpsSignatureSeverity.fromInt(reader.getInt());
                } else if ("direction".equals(fieldName)) {
                    deserializedSingleQueryResult.direction
                        = FirewallPolicyIdpsSignatureDirection.fromInt(reader.getInt());
                } else if ("group".equals(fieldName)) {
                    deserializedSingleQueryResult.group = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedSingleQueryResult.description = reader.getString();
                } else if ("protocol".equals(fieldName)) {
                    deserializedSingleQueryResult.protocol = reader.getString();
                } else if ("sourcePorts".equals(fieldName)) {
                    List<String> sourcePorts = reader.readArray(reader1 -> reader1.getString());
                    deserializedSingleQueryResult.sourcePorts = sourcePorts;
                } else if ("destinationPorts".equals(fieldName)) {
                    List<String> destinationPorts = reader.readArray(reader1 -> reader1.getString());
                    deserializedSingleQueryResult.destinationPorts = destinationPorts;
                } else if ("lastUpdated".equals(fieldName)) {
                    deserializedSingleQueryResult.lastUpdated = reader.getString();
                } else if ("inheritedFromParentPolicy".equals(fieldName)) {
                    deserializedSingleQueryResult.inheritedFromParentPolicy
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSingleQueryResult;
        });
    }
}
