// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ServiceEndpointPolicyDefinitionInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListServiceEndpointPolicyDefinition API service call. Retrieves all service endpoint policy definition
 * that belongs to a service endpoint policy.
 */
@Fluent
public final class ServiceEndpointPolicyDefinitionListResult
    implements JsonSerializable<ServiceEndpointPolicyDefinitionListResult> {
    /*
     * The service endpoint policy definition in a service endpoint policy.
     */
    private List<ServiceEndpointPolicyDefinitionInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ServiceEndpointPolicyDefinitionListResult class.
     */
    public ServiceEndpointPolicyDefinitionListResult() {
    }

    /**
     * Get the value property: The service endpoint policy definition in a service endpoint policy.
     * 
     * @return the value value.
     */
    public List<ServiceEndpointPolicyDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The service endpoint policy definition in a service endpoint policy.
     * 
     * @param value the value value to set.
     * @return the ServiceEndpointPolicyDefinitionListResult object itself.
     */
    public ServiceEndpointPolicyDefinitionListResult withValue(List<ServiceEndpointPolicyDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ServiceEndpointPolicyDefinitionListResult object itself.
     */
    public ServiceEndpointPolicyDefinitionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceEndpointPolicyDefinitionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceEndpointPolicyDefinitionListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServiceEndpointPolicyDefinitionListResult.
     */
    public static ServiceEndpointPolicyDefinitionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServiceEndpointPolicyDefinitionListResult deserializedServiceEndpointPolicyDefinitionListResult
                = new ServiceEndpointPolicyDefinitionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ServiceEndpointPolicyDefinitionInner> value
                        = reader.readArray(reader1 -> ServiceEndpointPolicyDefinitionInner.fromJson(reader1));
                    deserializedServiceEndpointPolicyDefinitionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedServiceEndpointPolicyDefinitionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServiceEndpointPolicyDefinitionListResult;
        });
    }
}
