// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network Virtual Appliance Sku Properties.
 */
@Fluent
public final class Office365PolicyProperties implements JsonSerializable<Office365PolicyProperties> {
    /*
     * Office 365 breakout categories.
     */
    private BreakOutCategoryPolicies breakOutCategories;

    /**
     * Creates an instance of Office365PolicyProperties class.
     */
    public Office365PolicyProperties() {
    }

    /**
     * Get the breakOutCategories property: Office 365 breakout categories.
     * 
     * @return the breakOutCategories value.
     */
    public BreakOutCategoryPolicies breakOutCategories() {
        return this.breakOutCategories;
    }

    /**
     * Set the breakOutCategories property: Office 365 breakout categories.
     * 
     * @param breakOutCategories the breakOutCategories value to set.
     * @return the Office365PolicyProperties object itself.
     */
    public Office365PolicyProperties withBreakOutCategories(BreakOutCategoryPolicies breakOutCategories) {
        this.breakOutCategories = breakOutCategories;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (breakOutCategories() != null) {
            breakOutCategories().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("breakOutCategories", this.breakOutCategories);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Office365PolicyProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Office365PolicyProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the Office365PolicyProperties.
     */
    public static Office365PolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Office365PolicyProperties deserializedOffice365PolicyProperties = new Office365PolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("breakOutCategories".equals(fieldName)) {
                    deserializedOffice365PolicyProperties.breakOutCategories
                        = BreakOutCategoryPolicies.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOffice365PolicyProperties;
        });
    }
}
