// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualHubRouteTableV2Inner;
import java.io.IOException;
import java.util.List;

/**
 * List of VirtualHubRouteTableV2s and a URL nextLink to get the next set of results.
 */
@Fluent
public final class ListVirtualHubRouteTableV2SResult implements JsonSerializable<ListVirtualHubRouteTableV2SResult> {
    /*
     * List of VirtualHubRouteTableV2s.
     */
    private List<VirtualHubRouteTableV2Inner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ListVirtualHubRouteTableV2SResult class.
     */
    public ListVirtualHubRouteTableV2SResult() {
    }

    /**
     * Get the value property: List of VirtualHubRouteTableV2s.
     * 
     * @return the value value.
     */
    public List<VirtualHubRouteTableV2Inner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of VirtualHubRouteTableV2s.
     * 
     * @param value the value value to set.
     * @return the ListVirtualHubRouteTableV2SResult object itself.
     */
    public ListVirtualHubRouteTableV2SResult withValue(List<VirtualHubRouteTableV2Inner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListVirtualHubRouteTableV2SResult object itself.
     */
    public ListVirtualHubRouteTableV2SResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListVirtualHubRouteTableV2SResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListVirtualHubRouteTableV2SResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListVirtualHubRouteTableV2SResult.
     */
    public static ListVirtualHubRouteTableV2SResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListVirtualHubRouteTableV2SResult deserializedListVirtualHubRouteTableV2SResult
                = new ListVirtualHubRouteTableV2SResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualHubRouteTableV2Inner> value
                        = reader.readArray(reader1 -> VirtualHubRouteTableV2Inner.fromJson(reader1));
                    deserializedListVirtualHubRouteTableV2SResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListVirtualHubRouteTableV2SResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListVirtualHubRouteTableV2SResult;
        });
    }
}
