// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Intrusion detection signatures specification states.
 */
@Fluent
public final class FirewallPolicyIntrusionDetectionSignatureSpecification
    implements JsonSerializable<FirewallPolicyIntrusionDetectionSignatureSpecification> {
    /*
     * Signature id.
     */
    private String id;

    /*
     * The signature state.
     */
    private FirewallPolicyIntrusionDetectionStateType mode;

    /**
     * Creates an instance of FirewallPolicyIntrusionDetectionSignatureSpecification class.
     */
    public FirewallPolicyIntrusionDetectionSignatureSpecification() {
    }

    /**
     * Get the id property: Signature id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Signature id.
     * 
     * @param id the id value to set.
     * @return the FirewallPolicyIntrusionDetectionSignatureSpecification object itself.
     */
    public FirewallPolicyIntrusionDetectionSignatureSpecification withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the mode property: The signature state.
     * 
     * @return the mode value.
     */
    public FirewallPolicyIntrusionDetectionStateType mode() {
        return this.mode;
    }

    /**
     * Set the mode property: The signature state.
     * 
     * @param mode the mode value to set.
     * @return the FirewallPolicyIntrusionDetectionSignatureSpecification object itself.
     */
    public FirewallPolicyIntrusionDetectionSignatureSpecification
        withMode(FirewallPolicyIntrusionDetectionStateType mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallPolicyIntrusionDetectionSignatureSpecification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallPolicyIntrusionDetectionSignatureSpecification if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallPolicyIntrusionDetectionSignatureSpecification.
     */
    public static FirewallPolicyIntrusionDetectionSignatureSpecification fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallPolicyIntrusionDetectionSignatureSpecification deserializedFirewallPolicyIntrusionDetectionSignatureSpecification
                = new FirewallPolicyIntrusionDetectionSignatureSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedFirewallPolicyIntrusionDetectionSignatureSpecification.id = reader.getString();
                } else if ("mode".equals(fieldName)) {
                    deserializedFirewallPolicyIntrusionDetectionSignatureSpecification.mode
                        = FirewallPolicyIntrusionDetectionStateType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallPolicyIntrusionDetectionSignatureSpecification;
        });
    }
}
