// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines a managed rule to use for exclusion.
 */
@Fluent
public final class ExclusionManagedRule implements JsonSerializable<ExclusionManagedRule> {
    /*
     * Identifier for the managed rule.
     */
    private String ruleId;

    /**
     * Creates an instance of ExclusionManagedRule class.
     */
    public ExclusionManagedRule() {
    }

    /**
     * Get the ruleId property: Identifier for the managed rule.
     * 
     * @return the ruleId value.
     */
    public String ruleId() {
        return this.ruleId;
    }

    /**
     * Set the ruleId property: Identifier for the managed rule.
     * 
     * @param ruleId the ruleId value to set.
     * @return the ExclusionManagedRule object itself.
     */
    public ExclusionManagedRule withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property ruleId in model ExclusionManagedRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExclusionManagedRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleId", this.ruleId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExclusionManagedRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExclusionManagedRule if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExclusionManagedRule.
     */
    public static ExclusionManagedRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExclusionManagedRule deserializedExclusionManagedRule = new ExclusionManagedRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleId".equals(fieldName)) {
                    deserializedExclusionManagedRule.ruleId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExclusionManagedRule;
        });
    }
}
