// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Adds exception to allow a request when the condition is satisfied.
 */
@Fluent
public final class ExceptionEntry implements JsonSerializable<ExceptionEntry> {
    /*
     * The variable on which we evaluate the exception condition
     */
    private ExceptionEntryMatchVariable matchVariable;

    /*
     * Allowed values for the matchVariable
     */
    private List<String> values;

    /*
     * Operates on the allowed values for the matchVariable
     */
    private ExceptionEntryValueMatchOperator valueMatchOperator;

    /*
     * When the matchVariable points to a key-value pair (e.g, RequestHeader), this operates on the selector
     */
    private ExceptionEntrySelectorMatchOperator selectorMatchOperator;

    /*
     * When the matchVariable points to a key-value pair (e.g, RequestHeader), this identifies the key.
     */
    private String selector;

    /*
     * The managed rule sets that are associated with the exception.
     */
    private List<ExclusionManagedRuleSet> exceptionManagedRuleSets;

    /**
     * Creates an instance of ExceptionEntry class.
     */
    public ExceptionEntry() {
    }

    /**
     * Get the matchVariable property: The variable on which we evaluate the exception condition.
     * 
     * @return the matchVariable value.
     */
    public ExceptionEntryMatchVariable matchVariable() {
        return this.matchVariable;
    }

    /**
     * Set the matchVariable property: The variable on which we evaluate the exception condition.
     * 
     * @param matchVariable the matchVariable value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withMatchVariable(ExceptionEntryMatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    /**
     * Get the values property: Allowed values for the matchVariable.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: Allowed values for the matchVariable.
     * 
     * @param values the values value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Get the valueMatchOperator property: Operates on the allowed values for the matchVariable.
     * 
     * @return the valueMatchOperator value.
     */
    public ExceptionEntryValueMatchOperator valueMatchOperator() {
        return this.valueMatchOperator;
    }

    /**
     * Set the valueMatchOperator property: Operates on the allowed values for the matchVariable.
     * 
     * @param valueMatchOperator the valueMatchOperator value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withValueMatchOperator(ExceptionEntryValueMatchOperator valueMatchOperator) {
        this.valueMatchOperator = valueMatchOperator;
        return this;
    }

    /**
     * Get the selectorMatchOperator property: When the matchVariable points to a key-value pair (e.g, RequestHeader),
     * this operates on the selector.
     * 
     * @return the selectorMatchOperator value.
     */
    public ExceptionEntrySelectorMatchOperator selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    /**
     * Set the selectorMatchOperator property: When the matchVariable points to a key-value pair (e.g, RequestHeader),
     * this operates on the selector.
     * 
     * @param selectorMatchOperator the selectorMatchOperator value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withSelectorMatchOperator(ExceptionEntrySelectorMatchOperator selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    /**
     * Get the selector property: When the matchVariable points to a key-value pair (e.g, RequestHeader), this
     * identifies the key.
     * 
     * @return the selector value.
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set the selector property: When the matchVariable points to a key-value pair (e.g, RequestHeader), this
     * identifies the key.
     * 
     * @param selector the selector value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    /**
     * Get the exceptionManagedRuleSets property: The managed rule sets that are associated with the exception.
     * 
     * @return the exceptionManagedRuleSets value.
     */
    public List<ExclusionManagedRuleSet> exceptionManagedRuleSets() {
        return this.exceptionManagedRuleSets;
    }

    /**
     * Set the exceptionManagedRuleSets property: The managed rule sets that are associated with the exception.
     * 
     * @param exceptionManagedRuleSets the exceptionManagedRuleSets value to set.
     * @return the ExceptionEntry object itself.
     */
    public ExceptionEntry withExceptionManagedRuleSets(List<ExclusionManagedRuleSet> exceptionManagedRuleSets) {
        this.exceptionManagedRuleSets = exceptionManagedRuleSets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchVariable() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property matchVariable in model ExceptionEntry"));
        }
        if (valueMatchOperator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property valueMatchOperator in model ExceptionEntry"));
        }
        if (exceptionManagedRuleSets() != null) {
            exceptionManagedRuleSets().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExceptionEntry.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("matchVariable", this.matchVariable == null ? null : this.matchVariable.toString());
        jsonWriter.writeStringField("valueMatchOperator",
            this.valueMatchOperator == null ? null : this.valueMatchOperator.toString());
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("selectorMatchOperator",
            this.selectorMatchOperator == null ? null : this.selectorMatchOperator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeArrayField("exceptionManagedRuleSets", this.exceptionManagedRuleSets,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExceptionEntry from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExceptionEntry if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExceptionEntry.
     */
    public static ExceptionEntry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExceptionEntry deserializedExceptionEntry = new ExceptionEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("matchVariable".equals(fieldName)) {
                    deserializedExceptionEntry.matchVariable
                        = ExceptionEntryMatchVariable.fromString(reader.getString());
                } else if ("valueMatchOperator".equals(fieldName)) {
                    deserializedExceptionEntry.valueMatchOperator
                        = ExceptionEntryValueMatchOperator.fromString(reader.getString());
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedExceptionEntry.values = values;
                } else if ("selectorMatchOperator".equals(fieldName)) {
                    deserializedExceptionEntry.selectorMatchOperator
                        = ExceptionEntrySelectorMatchOperator.fromString(reader.getString());
                } else if ("selector".equals(fieldName)) {
                    deserializedExceptionEntry.selector = reader.getString();
                } else if ("exceptionManagedRuleSets".equals(fieldName)) {
                    List<ExclusionManagedRuleSet> exceptionManagedRuleSets
                        = reader.readArray(reader1 -> ExclusionManagedRuleSet.fromJson(reader1));
                    deserializedExceptionEntry.exceptionManagedRuleSets = exceptionManagedRuleSets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExceptionEntry;
        });
    }
}
