// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The parameters specifying the resource whose effective routes are being requested.
 */
@Fluent
public final class EffectiveRoutesParameters implements JsonSerializable<EffectiveRoutesParameters> {
    /*
     * The resource whose effective routes are being requested.
     */
    private String resourceId;

    /*
     * The type of the specified resource like RouteTable, ExpressRouteConnection, HubVirtualNetworkConnection,
     * VpnConnection and P2SConnection.
     */
    private String virtualWanResourceType;

    /**
     * Creates an instance of EffectiveRoutesParameters class.
     */
    public EffectiveRoutesParameters() {
    }

    /**
     * Get the resourceId property: The resource whose effective routes are being requested.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The resource whose effective routes are being requested.
     * 
     * @param resourceId the resourceId value to set.
     * @return the EffectiveRoutesParameters object itself.
     */
    public EffectiveRoutesParameters withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the virtualWanResourceType property: The type of the specified resource like RouteTable,
     * ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
     * 
     * @return the virtualWanResourceType value.
     */
    public String virtualWanResourceType() {
        return this.virtualWanResourceType;
    }

    /**
     * Set the virtualWanResourceType property: The type of the specified resource like RouteTable,
     * ExpressRouteConnection, HubVirtualNetworkConnection, VpnConnection and P2SConnection.
     * 
     * @param virtualWanResourceType the virtualWanResourceType value to set.
     * @return the EffectiveRoutesParameters object itself.
     */
    public EffectiveRoutesParameters withVirtualWanResourceType(String virtualWanResourceType) {
        this.virtualWanResourceType = virtualWanResourceType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("virtualWanResourceType", this.virtualWanResourceType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveRoutesParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveRoutesParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveRoutesParameters.
     */
    public static EffectiveRoutesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRoutesParameters deserializedEffectiveRoutesParameters = new EffectiveRoutesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedEffectiveRoutesParameters.resourceId = reader.getString();
                } else if ("virtualWanResourceType".equals(fieldName)) {
                    deserializedEffectiveRoutesParameters.virtualWanResourceType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveRoutesParameters;
        });
    }
}
