// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The effective RouteMap route configured on the connection resource.
 */
@Fluent
public final class EffectiveRouteMapRoute implements JsonSerializable<EffectiveRouteMapRoute> {
    /*
     * The address prefix of the route.
     */
    private String prefix;

    /*
     * BGP communities of the route.
     */
    private String bgpCommunities;

    /*
     * The ASPath of this route.
     */
    private String asPath;

    /**
     * Creates an instance of EffectiveRouteMapRoute class.
     */
    public EffectiveRouteMapRoute() {
    }

    /**
     * Get the prefix property: The address prefix of the route.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The address prefix of the route.
     * 
     * @param prefix the prefix value to set.
     * @return the EffectiveRouteMapRoute object itself.
     */
    public EffectiveRouteMapRoute withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the bgpCommunities property: BGP communities of the route.
     * 
     * @return the bgpCommunities value.
     */
    public String bgpCommunities() {
        return this.bgpCommunities;
    }

    /**
     * Set the bgpCommunities property: BGP communities of the route.
     * 
     * @param bgpCommunities the bgpCommunities value to set.
     * @return the EffectiveRouteMapRoute object itself.
     */
    public EffectiveRouteMapRoute withBgpCommunities(String bgpCommunities) {
        this.bgpCommunities = bgpCommunities;
        return this;
    }

    /**
     * Get the asPath property: The ASPath of this route.
     * 
     * @return the asPath value.
     */
    public String asPath() {
        return this.asPath;
    }

    /**
     * Set the asPath property: The ASPath of this route.
     * 
     * @param asPath the asPath value to set.
     * @return the EffectiveRouteMapRoute object itself.
     */
    public EffectiveRouteMapRoute withAsPath(String asPath) {
        this.asPath = asPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeStringField("bgpCommunities", this.bgpCommunities);
        jsonWriter.writeStringField("asPath", this.asPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveRouteMapRoute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveRouteMapRoute if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveRouteMapRoute.
     */
    public static EffectiveRouteMapRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRouteMapRoute deserializedEffectiveRouteMapRoute = new EffectiveRouteMapRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("prefix".equals(fieldName)) {
                    deserializedEffectiveRouteMapRoute.prefix = reader.getString();
                } else if ("bgpCommunities".equals(fieldName)) {
                    deserializedEffectiveRouteMapRoute.bgpCommunities = reader.getString();
                } else if ("asPath".equals(fieldName)) {
                    deserializedEffectiveRouteMapRoute.asPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveRouteMapRoute;
        });
    }
}
