// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * DNS Proxy Settings in Firewall Policy.
 */
@Fluent
public final class DnsSettings implements JsonSerializable<DnsSettings> {
    /*
     * List of Custom DNS Servers.
     */
    private List<String> servers;

    /*
     * Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     */
    private Boolean enableProxy;

    /*
     * FQDNs in Network Rules are supported when set to true.
     */
    private Boolean requireProxyForNetworkRules;

    /**
     * Creates an instance of DnsSettings class.
     */
    public DnsSettings() {
    }

    /**
     * Get the servers property: List of Custom DNS Servers.
     * 
     * @return the servers value.
     */
    public List<String> servers() {
        return this.servers;
    }

    /**
     * Set the servers property: List of Custom DNS Servers.
     * 
     * @param servers the servers value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withServers(List<String> servers) {
        this.servers = servers;
        return this;
    }

    /**
     * Get the enableProxy property: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     * 
     * @return the enableProxy value.
     */
    public Boolean enableProxy() {
        return this.enableProxy;
    }

    /**
     * Set the enableProxy property: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     * 
     * @param enableProxy the enableProxy value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withEnableProxy(Boolean enableProxy) {
        this.enableProxy = enableProxy;
        return this;
    }

    /**
     * Get the requireProxyForNetworkRules property: FQDNs in Network Rules are supported when set to true.
     * 
     * @return the requireProxyForNetworkRules value.
     */
    public Boolean requireProxyForNetworkRules() {
        return this.requireProxyForNetworkRules;
    }

    /**
     * Set the requireProxyForNetworkRules property: FQDNs in Network Rules are supported when set to true.
     * 
     * @param requireProxyForNetworkRules the requireProxyForNetworkRules value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withRequireProxyForNetworkRules(Boolean requireProxyForNetworkRules) {
        this.requireProxyForNetworkRules = requireProxyForNetworkRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("servers", this.servers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enableProxy", this.enableProxy);
        jsonWriter.writeBooleanField("requireProxyForNetworkRules", this.requireProxyForNetworkRules);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnsSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnsSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DnsSettings.
     */
    public static DnsSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnsSettings deserializedDnsSettings = new DnsSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("servers".equals(fieldName)) {
                    List<String> servers = reader.readArray(reader1 -> reader1.getString());
                    deserializedDnsSettings.servers = servers;
                } else if ("enableProxy".equals(fieldName)) {
                    deserializedDnsSettings.enableProxy = reader.getNullable(JsonReader::getBoolean);
                } else if ("requireProxyForNetworkRules".equals(fieldName)) {
                    deserializedDnsSettings.requireProxyForNetworkRules = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnsSettings;
        });
    }
}
