// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Dimension of the metric.
 */
@Fluent
public final class Dimension implements JsonSerializable<Dimension> {
    /*
     * The name of the dimension.
     */
    private String name;

    /*
     * The display name of the dimension.
     */
    private String displayName;

    /*
     * The internal name of the dimension.
     */
    private String internalName;

    /**
     * Creates an instance of Dimension class.
     */
    public Dimension() {
    }

    /**
     * Get the name property: The name of the dimension.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the dimension.
     * 
     * @param name the name value to set.
     * @return the Dimension object itself.
     */
    public Dimension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The display name of the dimension.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the dimension.
     * 
     * @param displayName the displayName value to set.
     * @return the Dimension object itself.
     */
    public Dimension withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the internalName property: The internal name of the dimension.
     * 
     * @return the internalName value.
     */
    public String internalName() {
        return this.internalName;
    }

    /**
     * Set the internalName property: The internal name of the dimension.
     * 
     * @param internalName the internalName value to set.
     * @return the Dimension object itself.
     */
    public Dimension withInternalName(String internalName) {
        this.internalName = internalName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("internalName", this.internalName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Dimension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Dimension if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Dimension.
     */
    public static Dimension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Dimension deserializedDimension = new Dimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedDimension.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedDimension.displayName = reader.getString();
                } else if ("internalName".equals(fieldName)) {
                    deserializedDimension.internalName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDimension;
        });
    }
}
