// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectionSharedKeyResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The list of shared keys for the vpn link connection. It should only contain one shared key for each vpn link
 * connection.
 */
@Fluent
public final class ConnectionSharedKeyResultList implements JsonSerializable<ConnectionSharedKeyResultList> {
    /*
     * List of SharedKeys.
     */
    private List<ConnectionSharedKeyResultInner> value;

    /*
     * URL to get the next set of operation list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of ConnectionSharedKeyResultList class.
     */
    public ConnectionSharedKeyResultList() {
    }

    /**
     * Get the value property: List of SharedKeys.
     * 
     * @return the value value.
     */
    public List<ConnectionSharedKeyResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of SharedKeys.
     * 
     * @param value the value value to set.
     * @return the ConnectionSharedKeyResultList object itself.
     */
    public ConnectionSharedKeyResultList withValue(List<ConnectionSharedKeyResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of operation list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ConnectionSharedKeyResultList object itself.
     */
    public ConnectionSharedKeyResultList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionSharedKeyResultList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionSharedKeyResultList if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionSharedKeyResultList.
     */
    public static ConnectionSharedKeyResultList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionSharedKeyResultList deserializedConnectionSharedKeyResultList
                = new ConnectionSharedKeyResultList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ConnectionSharedKeyResultInner> value
                        = reader.readArray(reader1 -> ConnectionSharedKeyResultInner.fromJson(reader1));
                    deserializedConnectionSharedKeyResultList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedConnectionSharedKeyResultList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionSharedKeyResultList;
        });
    }
}
