// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the connection monitor endpoint scope item.
 */
@Fluent
public final class ConnectionMonitorEndpointScopeItem implements JsonSerializable<ConnectionMonitorEndpointScopeItem> {
    /*
     * The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
     */
    private String address;

    /**
     * Creates an instance of ConnectionMonitorEndpointScopeItem class.
     */
    public ConnectionMonitorEndpointScopeItem() {
    }

    /**
     * Get the address property: The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or
     * IPv4/IPv6 IP address.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or
     * IPv4/IPv6 IP address.
     * 
     * @param address the address value to set.
     * @return the ConnectionMonitorEndpointScopeItem object itself.
     */
    public ConnectionMonitorEndpointScopeItem withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorEndpointScopeItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorEndpointScopeItem if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorEndpointScopeItem.
     */
    public static ConnectionMonitorEndpointScopeItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorEndpointScopeItem deserializedConnectionMonitorEndpointScopeItem
                = new ConnectionMonitorEndpointScopeItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedConnectionMonitorEndpointScopeItem.address = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorEndpointScopeItem;
        });
    }
}
