// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the connection monitor endpoint filter.
 */
@Fluent
public final class ConnectionMonitorEndpointFilter implements JsonSerializable<ConnectionMonitorEndpointFilter> {
    /*
     * The behavior of the endpoint filter. Currently only 'Include' is supported.
     */
    private ConnectionMonitorEndpointFilterType type;

    /*
     * List of items in the filter.
     */
    private List<ConnectionMonitorEndpointFilterItem> items;

    /**
     * Creates an instance of ConnectionMonitorEndpointFilter class.
     */
    public ConnectionMonitorEndpointFilter() {
    }

    /**
     * Get the type property: The behavior of the endpoint filter. Currently only 'Include' is supported.
     * 
     * @return the type value.
     */
    public ConnectionMonitorEndpointFilterType type() {
        return this.type;
    }

    /**
     * Set the type property: The behavior of the endpoint filter. Currently only 'Include' is supported.
     * 
     * @param type the type value to set.
     * @return the ConnectionMonitorEndpointFilter object itself.
     */
    public ConnectionMonitorEndpointFilter withType(ConnectionMonitorEndpointFilterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the items property: List of items in the filter.
     * 
     * @return the items value.
     */
    public List<ConnectionMonitorEndpointFilterItem> items() {
        return this.items;
    }

    /**
     * Set the items property: List of items in the filter.
     * 
     * @param items the items value to set.
     * @return the ConnectionMonitorEndpointFilter object itself.
     */
    public ConnectionMonitorEndpointFilter withItems(List<ConnectionMonitorEndpointFilterItem> items) {
        this.items = items;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (items() != null) {
            items().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorEndpointFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorEndpointFilter if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorEndpointFilter.
     */
    public static ConnectionMonitorEndpointFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorEndpointFilter deserializedConnectionMonitorEndpointFilter
                = new ConnectionMonitorEndpointFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedConnectionMonitorEndpointFilter.type
                        = ConnectionMonitorEndpointFilterType.fromString(reader.getString());
                } else if ("items".equals(fieldName)) {
                    List<ConnectionMonitorEndpointFilterItem> items
                        = reader.readArray(reader1 -> ConnectionMonitorEndpointFilterItem.fromJson(reader1));
                    deserializedConnectionMonitorEndpointFilter.items = items;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorEndpointFilter;
        });
    }
}
