// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters that define a geographic location.
 */
@Fluent
public final class AzureReachabilityReportLocation implements JsonSerializable<AzureReachabilityReportLocation> {
    /*
     * The name of the country.
     */
    private String country;

    /*
     * The name of the state.
     */
    private String state;

    /*
     * The name of the city or town.
     */
    private String city;

    /**
     * Creates an instance of AzureReachabilityReportLocation class.
     */
    public AzureReachabilityReportLocation() {
    }

    /**
     * Get the country property: The name of the country.
     * 
     * @return the country value.
     */
    public String country() {
        return this.country;
    }

    /**
     * Set the country property: The name of the country.
     * 
     * @param country the country value to set.
     * @return the AzureReachabilityReportLocation object itself.
     */
    public AzureReachabilityReportLocation withCountry(String country) {
        this.country = country;
        return this;
    }

    /**
     * Get the state property: The name of the state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The name of the state.
     * 
     * @param state the state value to set.
     * @return the AzureReachabilityReportLocation object itself.
     */
    public AzureReachabilityReportLocation withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the city property: The name of the city or town.
     * 
     * @return the city value.
     */
    public String city() {
        return this.city;
    }

    /**
     * Set the city property: The name of the city or town.
     * 
     * @param city the city value to set.
     * @return the AzureReachabilityReportLocation object itself.
     */
    public AzureReachabilityReportLocation withCity(String city) {
        this.city = city;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (country() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property country in model AzureReachabilityReportLocation"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureReachabilityReportLocation.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("city", this.city);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureReachabilityReportLocation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureReachabilityReportLocation if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureReachabilityReportLocation.
     */
    public static AzureReachabilityReportLocation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureReachabilityReportLocation deserializedAzureReachabilityReportLocation
                = new AzureReachabilityReportLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("country".equals(fieldName)) {
                    deserializedAzureReachabilityReportLocation.country = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedAzureReachabilityReportLocation.state = reader.getString();
                } else if ("city".equals(fieldName)) {
                    deserializedAzureReachabilityReportLocation.city = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureReachabilityReportLocation;
        });
    }
}
