// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU of an Azure Firewall.
 */
@Fluent
public final class AzureFirewallSku implements JsonSerializable<AzureFirewallSku> {
    /*
     * Name of an Azure Firewall SKU.
     */
    private AzureFirewallSkuName name;

    /*
     * Tier of an Azure Firewall.
     */
    private AzureFirewallSkuTier tier;

    /**
     * Creates an instance of AzureFirewallSku class.
     */
    public AzureFirewallSku() {
    }

    /**
     * Get the name property: Name of an Azure Firewall SKU.
     * 
     * @return the name value.
     */
    public AzureFirewallSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Name of an Azure Firewall SKU.
     * 
     * @param name the name value to set.
     * @return the AzureFirewallSku object itself.
     */
    public AzureFirewallSku withName(AzureFirewallSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier property: Tier of an Azure Firewall.
     * 
     * @return the tier value.
     */
    public AzureFirewallSkuTier tier() {
        return this.tier;
    }

    /**
     * Set the tier property: Tier of an Azure Firewall.
     * 
     * @param tier the tier value to set.
     * @return the AzureFirewallSku object itself.
     */
    public AzureFirewallSku withTier(AzureFirewallSkuTier tier) {
        this.tier = tier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallSku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallSku.
     */
    public static AzureFirewallSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallSku deserializedAzureFirewallSku = new AzureFirewallSku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAzureFirewallSku.name = AzureFirewallSkuName.fromString(reader.getString());
                } else if ("tier".equals(fieldName)) {
                    deserializedAzureFirewallSku.tier = AzureFirewallSkuTier.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallSku;
        });
    }
}
