// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Set of actions in the Rewrite Rule in Application Gateway.
 */
@Fluent
public final class ApplicationGatewayRewriteRuleActionSet
    implements JsonSerializable<ApplicationGatewayRewriteRuleActionSet> {
    /*
     * Request Header Actions in the Action Set.
     */
    private List<ApplicationGatewayHeaderConfiguration> requestHeaderConfigurations;

    /*
     * Response Header Actions in the Action Set.
     */
    private List<ApplicationGatewayHeaderConfiguration> responseHeaderConfigurations;

    /*
     * Url Configuration Action in the Action Set.
     */
    private ApplicationGatewayUrlConfiguration urlConfiguration;

    /**
     * Creates an instance of ApplicationGatewayRewriteRuleActionSet class.
     */
    public ApplicationGatewayRewriteRuleActionSet() {
    }

    /**
     * Get the requestHeaderConfigurations property: Request Header Actions in the Action Set.
     * 
     * @return the requestHeaderConfigurations value.
     */
    public List<ApplicationGatewayHeaderConfiguration> requestHeaderConfigurations() {
        return this.requestHeaderConfigurations;
    }

    /**
     * Set the requestHeaderConfigurations property: Request Header Actions in the Action Set.
     * 
     * @param requestHeaderConfigurations the requestHeaderConfigurations value to set.
     * @return the ApplicationGatewayRewriteRuleActionSet object itself.
     */
    public ApplicationGatewayRewriteRuleActionSet
        withRequestHeaderConfigurations(List<ApplicationGatewayHeaderConfiguration> requestHeaderConfigurations) {
        this.requestHeaderConfigurations = requestHeaderConfigurations;
        return this;
    }

    /**
     * Get the responseHeaderConfigurations property: Response Header Actions in the Action Set.
     * 
     * @return the responseHeaderConfigurations value.
     */
    public List<ApplicationGatewayHeaderConfiguration> responseHeaderConfigurations() {
        return this.responseHeaderConfigurations;
    }

    /**
     * Set the responseHeaderConfigurations property: Response Header Actions in the Action Set.
     * 
     * @param responseHeaderConfigurations the responseHeaderConfigurations value to set.
     * @return the ApplicationGatewayRewriteRuleActionSet object itself.
     */
    public ApplicationGatewayRewriteRuleActionSet
        withResponseHeaderConfigurations(List<ApplicationGatewayHeaderConfiguration> responseHeaderConfigurations) {
        this.responseHeaderConfigurations = responseHeaderConfigurations;
        return this;
    }

    /**
     * Get the urlConfiguration property: Url Configuration Action in the Action Set.
     * 
     * @return the urlConfiguration value.
     */
    public ApplicationGatewayUrlConfiguration urlConfiguration() {
        return this.urlConfiguration;
    }

    /**
     * Set the urlConfiguration property: Url Configuration Action in the Action Set.
     * 
     * @param urlConfiguration the urlConfiguration value to set.
     * @return the ApplicationGatewayRewriteRuleActionSet object itself.
     */
    public ApplicationGatewayRewriteRuleActionSet
        withUrlConfiguration(ApplicationGatewayUrlConfiguration urlConfiguration) {
        this.urlConfiguration = urlConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (requestHeaderConfigurations() != null) {
            requestHeaderConfigurations().forEach(e -> e.validate());
        }
        if (responseHeaderConfigurations() != null) {
            responseHeaderConfigurations().forEach(e -> e.validate());
        }
        if (urlConfiguration() != null) {
            urlConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("requestHeaderConfigurations", this.requestHeaderConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("responseHeaderConfigurations", this.responseHeaderConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("urlConfiguration", this.urlConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayRewriteRuleActionSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayRewriteRuleActionSet if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayRewriteRuleActionSet.
     */
    public static ApplicationGatewayRewriteRuleActionSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayRewriteRuleActionSet deserializedApplicationGatewayRewriteRuleActionSet
                = new ApplicationGatewayRewriteRuleActionSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requestHeaderConfigurations".equals(fieldName)) {
                    List<ApplicationGatewayHeaderConfiguration> requestHeaderConfigurations
                        = reader.readArray(reader1 -> ApplicationGatewayHeaderConfiguration.fromJson(reader1));
                    deserializedApplicationGatewayRewriteRuleActionSet.requestHeaderConfigurations
                        = requestHeaderConfigurations;
                } else if ("responseHeaderConfigurations".equals(fieldName)) {
                    List<ApplicationGatewayHeaderConfiguration> responseHeaderConfigurations
                        = reader.readArray(reader1 -> ApplicationGatewayHeaderConfiguration.fromJson(reader1));
                    deserializedApplicationGatewayRewriteRuleActionSet.responseHeaderConfigurations
                        = responseHeaderConfigurations;
                } else if ("urlConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayRewriteRuleActionSet.urlConfiguration
                        = ApplicationGatewayUrlConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayRewriteRuleActionSet;
        });
    }
}
