// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application Gateway global configuration.
 */
@Fluent
public final class ApplicationGatewayGlobalConfiguration
    implements JsonSerializable<ApplicationGatewayGlobalConfiguration> {
    /*
     * Enable request buffering.
     */
    private Boolean enableRequestBuffering;

    /*
     * Enable response buffering.
     */
    private Boolean enableResponseBuffering;

    /**
     * Creates an instance of ApplicationGatewayGlobalConfiguration class.
     */
    public ApplicationGatewayGlobalConfiguration() {
    }

    /**
     * Get the enableRequestBuffering property: Enable request buffering.
     * 
     * @return the enableRequestBuffering value.
     */
    public Boolean enableRequestBuffering() {
        return this.enableRequestBuffering;
    }

    /**
     * Set the enableRequestBuffering property: Enable request buffering.
     * 
     * @param enableRequestBuffering the enableRequestBuffering value to set.
     * @return the ApplicationGatewayGlobalConfiguration object itself.
     */
    public ApplicationGatewayGlobalConfiguration withEnableRequestBuffering(Boolean enableRequestBuffering) {
        this.enableRequestBuffering = enableRequestBuffering;
        return this;
    }

    /**
     * Get the enableResponseBuffering property: Enable response buffering.
     * 
     * @return the enableResponseBuffering value.
     */
    public Boolean enableResponseBuffering() {
        return this.enableResponseBuffering;
    }

    /**
     * Set the enableResponseBuffering property: Enable response buffering.
     * 
     * @param enableResponseBuffering the enableResponseBuffering value to set.
     * @return the ApplicationGatewayGlobalConfiguration object itself.
     */
    public ApplicationGatewayGlobalConfiguration withEnableResponseBuffering(Boolean enableResponseBuffering) {
        this.enableResponseBuffering = enableResponseBuffering;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enableRequestBuffering", this.enableRequestBuffering);
        jsonWriter.writeBooleanField("enableResponseBuffering", this.enableResponseBuffering);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayGlobalConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayGlobalConfiguration if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayGlobalConfiguration.
     */
    public static ApplicationGatewayGlobalConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayGlobalConfiguration deserializedApplicationGatewayGlobalConfiguration
                = new ApplicationGatewayGlobalConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enableRequestBuffering".equals(fieldName)) {
                    deserializedApplicationGatewayGlobalConfiguration.enableRequestBuffering
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableResponseBuffering".equals(fieldName)) {
                    deserializedApplicationGatewayGlobalConfiguration.enableResponseBuffering
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayGlobalConfiguration;
        });
    }
}
