// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Effective Virtual Networks Parameter.
 */
@Fluent
public final class ActiveConfigurationParameter implements JsonSerializable<ActiveConfigurationParameter> {
    /*
     * List of regions.
     */
    private List<String> regions;

    /*
     * When present, the value can be passed to a subsequent query call (together with the same query and scopes used in
     * the current request) to retrieve the next page of data.
     */
    private String skipToken;

    /**
     * Creates an instance of ActiveConfigurationParameter class.
     */
    public ActiveConfigurationParameter() {
    }

    /**
     * Get the regions property: List of regions.
     * 
     * @return the regions value.
     */
    public List<String> regions() {
        return this.regions;
    }

    /**
     * Set the regions property: List of regions.
     * 
     * @param regions the regions value to set.
     * @return the ActiveConfigurationParameter object itself.
     */
    public ActiveConfigurationParameter withRegions(List<String> regions) {
        this.regions = regions;
        return this;
    }

    /**
     * Get the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @return the skipToken value.
     */
    public String skipToken() {
        return this.skipToken;
    }

    /**
     * Set the skipToken property: When present, the value can be passed to a subsequent query call (together with the
     * same query and scopes used in the current request) to retrieve the next page of data.
     * 
     * @param skipToken the skipToken value to set.
     * @return the ActiveConfigurationParameter object itself.
     */
    public ActiveConfigurationParameter withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("regions", this.regions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActiveConfigurationParameter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActiveConfigurationParameter if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ActiveConfigurationParameter.
     */
    public static ActiveConfigurationParameter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveConfigurationParameter deserializedActiveConfigurationParameter = new ActiveConfigurationParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("regions".equals(fieldName)) {
                    List<String> regions = reader.readArray(reader1 -> reader1.getString());
                    deserializedActiveConfigurationParameter.regions = regions;
                } else if ("skipToken".equals(fieldName)) {
                    deserializedActiveConfigurationParameter.skipToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActiveConfigurationParameter;
        });
    }
}
