// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnLinkBgpSettings;
import com.azure.resourcemanager.network.models.VpnLinkProviderProperties;
import java.io.IOException;

/**
 * VpnSiteLink Resource.
 */
@Fluent
public final class VpnSiteLinkInner extends SubResource {
    /*
     * Properties of the VPN site link.
     */
    private VpnSiteLinkProperties innerProperties;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * Resource type.
     */
    private String type;

    /**
     * Creates an instance of VpnSiteLinkInner class.
     */
    public VpnSiteLinkInner() {
    }

    /**
     * Get the innerProperties property: Properties of the VPN site link.
     * 
     * @return the innerProperties value.
     */
    private VpnSiteLinkProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the VpnSiteLinkInner object itself.
     */
    public VpnSiteLinkInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VpnSiteLinkInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the linkProperties property: The link provider properties.
     * 
     * @return the linkProperties value.
     */
    public VpnLinkProviderProperties linkProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().linkProperties();
    }

    /**
     * Set the linkProperties property: The link provider properties.
     * 
     * @param linkProperties the linkProperties value to set.
     * @return the VpnSiteLinkInner object itself.
     */
    public VpnSiteLinkInner withLinkProperties(VpnLinkProviderProperties linkProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkProperties();
        }
        this.innerProperties().withLinkProperties(linkProperties);
        return this;
    }

    /**
     * Get the ipAddress property: The ip-address for the vpn-site-link.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    /**
     * Set the ipAddress property: The ip-address for the vpn-site-link.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the VpnSiteLinkInner object itself.
     */
    public VpnSiteLinkInner withIpAddress(String ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    /**
     * Get the fqdn property: FQDN of vpn-site-link.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    /**
     * Set the fqdn property: FQDN of vpn-site-link.
     * 
     * @param fqdn the fqdn value to set.
     * @return the VpnSiteLinkInner object itself.
     */
    public VpnSiteLinkInner withFqdn(String fqdn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkProperties();
        }
        this.innerProperties().withFqdn(fqdn);
        return this;
    }

    /**
     * Get the bgpProperties property: The set of bgp properties.
     * 
     * @return the bgpProperties value.
     */
    public VpnLinkBgpSettings bgpProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().bgpProperties();
    }

    /**
     * Set the bgpProperties property: The set of bgp properties.
     * 
     * @param bgpProperties the bgpProperties value to set.
     * @return the VpnSiteLinkInner object itself.
     */
    public VpnSiteLinkInner withBgpProperties(VpnLinkBgpSettings bgpProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VpnSiteLinkProperties();
        }
        this.innerProperties().withBgpProperties(bgpProperties);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VPN site link resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnSiteLinkInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnSiteLinkInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnSiteLinkInner.
     */
    public static VpnSiteLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnSiteLinkInner deserializedVpnSiteLinkInner = new VpnSiteLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVpnSiteLinkInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVpnSiteLinkInner.innerProperties = VpnSiteLinkProperties.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedVpnSiteLinkInner.etag = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVpnSiteLinkInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVpnSiteLinkInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnSiteLinkInner;
        });
    }
}
