// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.DisableBgpRoutePropagation;
import com.azure.resourcemanager.network.models.NetworkManagerRoutingGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Defines the routing rule collection.
 */
@Fluent
public final class RoutingRuleCollectionInner extends ChildResource {
    /*
     * Indicates the properties for the network manager routing rule collection.
     */
    private RoutingRuleCollectionPropertiesFormat innerProperties;

    /*
     * The system metadata related to this resource.
     */
    private SystemData systemData;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of RoutingRuleCollectionInner class.
     */
    public RoutingRuleCollectionInner() {
    }

    /**
     * Get the innerProperties property: Indicates the properties for the network manager routing rule collection.
     * 
     * @return the innerProperties value.
     */
    private RoutingRuleCollectionPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the description property: A description of the routing rule collection.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description of the routing rule collection.
     * 
     * @param description the description value to set.
     * @return the RoutingRuleCollectionInner object itself.
     */
    public RoutingRuleCollectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Get the appliesTo property: Groups for configuration.
     * 
     * @return the appliesTo value.
     */
    public List<NetworkManagerRoutingGroupItem> appliesTo() {
        return this.innerProperties() == null ? null : this.innerProperties().appliesTo();
    }

    /**
     * Set the appliesTo property: Groups for configuration.
     * 
     * @param appliesTo the appliesTo value to set.
     * @return the RoutingRuleCollectionInner object itself.
     */
    public RoutingRuleCollectionInner withAppliesTo(List<NetworkManagerRoutingGroupItem> appliesTo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withAppliesTo(appliesTo);
        return this;
    }

    /**
     * Get the disableBgpRoutePropagation property: Determines whether BGP route propagation is enabled. Defaults to
     * true.
     * 
     * @return the disableBgpRoutePropagation value.
     */
    public DisableBgpRoutePropagation disableBgpRoutePropagation() {
        return this.innerProperties() == null ? null : this.innerProperties().disableBgpRoutePropagation();
    }

    /**
     * Set the disableBgpRoutePropagation property: Determines whether BGP route propagation is enabled. Defaults to
     * true.
     * 
     * @param disableBgpRoutePropagation the disableBgpRoutePropagation value to set.
     * @return the RoutingRuleCollectionInner object itself.
     */
    public RoutingRuleCollectionInner
        withDisableBgpRoutePropagation(DisableBgpRoutePropagation disableBgpRoutePropagation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingRuleCollectionPropertiesFormat();
        }
        this.innerProperties().withDisableBgpRoutePropagation(disableBgpRoutePropagation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoutingRuleCollectionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoutingRuleCollectionInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RoutingRuleCollectionInner.
     */
    public static RoutingRuleCollectionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoutingRuleCollectionInner deserializedRoutingRuleCollectionInner = new RoutingRuleCollectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.etag = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.innerProperties
                        = RoutingRuleCollectionPropertiesFormat.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedRoutingRuleCollectionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoutingRuleCollectionInner;
        });
    }
}
