// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Network Security Group resource.
 */
@Fluent
public final class NetworkSecurityGroupPropertiesFormat
    implements JsonSerializable<NetworkSecurityGroupPropertiesFormat> {
    /*
     * When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates.
     * Initial enablement will trigger re-evaluation.
     */
    private Boolean flushConnection;

    /*
     * A collection of security rules of the network security group.
     */
    private List<SecurityRuleInner> securityRules;

    /*
     * The default security rules of network security group.
     */
    private List<SecurityRuleInner> defaultSecurityRules;

    /*
     * A collection of references to network interfaces.
     */
    private List<NetworkInterfaceInner> networkInterfaces;

    /*
     * A collection of references to subnets.
     */
    private List<SubnetInner> subnets;

    /*
     * A collection of references to flow log resources.
     */
    private List<FlowLogInner> flowLogs;

    /*
     * The resource GUID property of the network security group resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the network security group resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of NetworkSecurityGroupPropertiesFormat class.
     */
    public NetworkSecurityGroupPropertiesFormat() {
    }

    /**
     * Get the flushConnection property: When enabled, flows created from Network Security Group connections will be
     * re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     * 
     * @return the flushConnection value.
     */
    public Boolean flushConnection() {
        return this.flushConnection;
    }

    /**
     * Set the flushConnection property: When enabled, flows created from Network Security Group connections will be
     * re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     * 
     * @param flushConnection the flushConnection value to set.
     * @return the NetworkSecurityGroupPropertiesFormat object itself.
     */
    public NetworkSecurityGroupPropertiesFormat withFlushConnection(Boolean flushConnection) {
        this.flushConnection = flushConnection;
        return this;
    }

    /**
     * Get the securityRules property: A collection of security rules of the network security group.
     * 
     * @return the securityRules value.
     */
    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    /**
     * Set the securityRules property: A collection of security rules of the network security group.
     * 
     * @param securityRules the securityRules value to set.
     * @return the NetworkSecurityGroupPropertiesFormat object itself.
     */
    public NetworkSecurityGroupPropertiesFormat withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    /**
     * Get the defaultSecurityRules property: The default security rules of network security group.
     * 
     * @return the defaultSecurityRules value.
     */
    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    /**
     * Get the networkInterfaces property: A collection of references to network interfaces.
     * 
     * @return the networkInterfaces value.
     */
    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    /**
     * Get the subnets property: A collection of references to subnets.
     * 
     * @return the subnets value.
     */
    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    /**
     * Get the flowLogs property: A collection of references to flow log resources.
     * 
     * @return the flowLogs value.
     */
    public List<FlowLogInner> flowLogs() {
        return this.flowLogs;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the network security group resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the network security group resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (securityRules() != null) {
            securityRules().forEach(e -> e.validate());
        }
        if (defaultSecurityRules() != null) {
            defaultSecurityRules().forEach(e -> e.validate());
        }
        if (networkInterfaces() != null) {
            networkInterfaces().forEach(e -> e.validate());
        }
        if (subnets() != null) {
            subnets().forEach(e -> e.validate());
        }
        if (flowLogs() != null) {
            flowLogs().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("flushConnection", this.flushConnection);
        jsonWriter.writeArrayField("securityRules", this.securityRules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityGroupPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityGroupPropertiesFormat if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityGroupPropertiesFormat.
     */
    public static NetworkSecurityGroupPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityGroupPropertiesFormat deserializedNetworkSecurityGroupPropertiesFormat
                = new NetworkSecurityGroupPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("flushConnection".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.flushConnection
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("securityRules".equals(fieldName)) {
                    List<SecurityRuleInner> securityRules
                        = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.securityRules = securityRules;
                } else if ("defaultSecurityRules".equals(fieldName)) {
                    List<SecurityRuleInner> defaultSecurityRules
                        = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.defaultSecurityRules = defaultSecurityRules;
                } else if ("networkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceInner> networkInterfaces
                        = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.networkInterfaces = networkInterfaces;
                } else if ("subnets".equals(fieldName)) {
                    List<SubnetInner> subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.subnets = subnets;
                } else if ("flowLogs".equals(fieldName)) {
                    List<FlowLogInner> flowLogs = reader.readArray(reader1 -> FlowLogInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.flowLogs = flowLogs;
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityGroupPropertiesFormat;
        });
    }
}
