// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * IP configuration profile properties.
 */
@Fluent
public final class IpConfigurationProfilePropertiesFormatInner
    implements JsonSerializable<IpConfigurationProfilePropertiesFormatInner> {
    /*
     * The reference to the subnet resource to create a container network interface ip configuration.
     */
    private SubnetInner subnet;

    /*
     * The provisioning state of the IP configuration profile resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of IpConfigurationProfilePropertiesFormatInner class.
     */
    public IpConfigurationProfilePropertiesFormatInner() {
    }

    /**
     * Get the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     * 
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     * 
     * @param subnet the subnet value to set.
     * @return the IpConfigurationProfilePropertiesFormatInner object itself.
     */
    public IpConfigurationProfilePropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the IP configuration profile resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", this.subnet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpConfigurationProfilePropertiesFormatInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpConfigurationProfilePropertiesFormatInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpConfigurationProfilePropertiesFormatInner.
     */
    public static IpConfigurationProfilePropertiesFormatInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpConfigurationProfilePropertiesFormatInner deserializedIpConfigurationProfilePropertiesFormatInner
                = new IpConfigurationProfilePropertiesFormatInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnet".equals(fieldName)) {
                    deserializedIpConfigurationProfilePropertiesFormatInner.subnet = SubnetInner.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedIpConfigurationProfilePropertiesFormatInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpConfigurationProfilePropertiesFormatInner;
        });
    }
}
