// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationType;
import com.azure.resourcemanager.network.models.IpVersion;
import java.io.IOException;
import java.util.Map;

/**
 * Properties of the IpAllocation.
 */
@Fluent
public final class IpAllocationPropertiesFormat implements JsonSerializable<IpAllocationPropertiesFormat> {
    /*
     * The Subnet that using the prefix of this IpAllocation resource.
     */
    private SubResource subnet;

    /*
     * The VirtualNetwork that using the prefix of this IpAllocation resource.
     */
    private SubResource virtualNetwork;

    /*
     * The type for the IpAllocation.
     */
    private IpAllocationType type;

    /*
     * The address prefix for the IpAllocation.
     */
    private String prefix;

    /*
     * The address prefix length for the IpAllocation.
     */
    private Integer prefixLength;

    /*
     * The address prefix Type for the IpAllocation.
     */
    private IpVersion prefixType;

    /*
     * The IPAM allocation ID.
     */
    private String ipamAllocationId;

    /*
     * IpAllocation tags.
     */
    private Map<String, String> allocationTags;

    /**
     * Creates an instance of IpAllocationPropertiesFormat class.
     */
    public IpAllocationPropertiesFormat() {
    }

    /**
     * Get the subnet property: The Subnet that using the prefix of this IpAllocation resource.
     * 
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Get the virtualNetwork property: The VirtualNetwork that using the prefix of this IpAllocation resource.
     * 
     * @return the virtualNetwork value.
     */
    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    /**
     * Get the type property: The type for the IpAllocation.
     * 
     * @return the type value.
     */
    public IpAllocationType type() {
        return this.type;
    }

    /**
     * Set the type property: The type for the IpAllocation.
     * 
     * @param type the type value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withType(IpAllocationType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the prefix property: The address prefix for the IpAllocation.
     * 
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The address prefix for the IpAllocation.
     * 
     * @param prefix the prefix value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the prefixLength property: The address prefix length for the IpAllocation.
     * 
     * @return the prefixLength value.
     */
    public Integer prefixLength() {
        return this.prefixLength;
    }

    /**
     * Set the prefixLength property: The address prefix length for the IpAllocation.
     * 
     * @param prefixLength the prefixLength value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefixLength(Integer prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    /**
     * Get the prefixType property: The address prefix Type for the IpAllocation.
     * 
     * @return the prefixType value.
     */
    public IpVersion prefixType() {
        return this.prefixType;
    }

    /**
     * Set the prefixType property: The address prefix Type for the IpAllocation.
     * 
     * @param prefixType the prefixType value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withPrefixType(IpVersion prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    /**
     * Get the ipamAllocationId property: The IPAM allocation ID.
     * 
     * @return the ipamAllocationId value.
     */
    public String ipamAllocationId() {
        return this.ipamAllocationId;
    }

    /**
     * Set the ipamAllocationId property: The IPAM allocation ID.
     * 
     * @param ipamAllocationId the ipamAllocationId value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withIpamAllocationId(String ipamAllocationId) {
        this.ipamAllocationId = ipamAllocationId;
        return this;
    }

    /**
     * Get the allocationTags property: IpAllocation tags.
     * 
     * @return the allocationTags value.
     */
    public Map<String, String> allocationTags() {
        return this.allocationTags;
    }

    /**
     * Set the allocationTags property: IpAllocation tags.
     * 
     * @param allocationTags the allocationTags value to set.
     * @return the IpAllocationPropertiesFormat object itself.
     */
    public IpAllocationPropertiesFormat withAllocationTags(Map<String, String> allocationTags) {
        this.allocationTags = allocationTags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("prefix", this.prefix);
        jsonWriter.writeNumberField("prefixLength", this.prefixLength);
        jsonWriter.writeStringField("prefixType", this.prefixType == null ? null : this.prefixType.toString());
        jsonWriter.writeStringField("ipamAllocationId", this.ipamAllocationId);
        jsonWriter.writeMapField("allocationTags", this.allocationTags,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAllocationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAllocationPropertiesFormat if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpAllocationPropertiesFormat.
     */
    public static IpAllocationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAllocationPropertiesFormat deserializedIpAllocationPropertiesFormat = new IpAllocationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnet".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.subnet = SubResource.fromJson(reader);
                } else if ("virtualNetwork".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.virtualNetwork = SubResource.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.type = IpAllocationType.fromString(reader.getString());
                } else if ("prefix".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefix = reader.getString();
                } else if ("prefixLength".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefixLength = reader.getNullable(JsonReader::getInt);
                } else if ("prefixType".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.prefixType = IpVersion.fromString(reader.getString());
                } else if ("ipamAllocationId".equals(fieldName)) {
                    deserializedIpAllocationPropertiesFormat.ipamAllocationId = reader.getString();
                } else if ("allocationTags".equals(fieldName)) {
                    Map<String, String> allocationTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIpAllocationPropertiesFormat.allocationTags = allocationTags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAllocationPropertiesFormat;
        });
    }
}
