// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommissionedState;
import com.azure.resourcemanager.network.models.CustomIpPrefixType;
import com.azure.resourcemanager.network.models.Geo;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Custom IP prefix properties.
 */
@Fluent
public final class CustomIpPrefixPropertiesFormat implements JsonSerializable<CustomIpPrefixPropertiesFormat> {
    /*
     * The ASN for CIDR advertising. Should be an integer as string.
     */
    private String asn;

    /*
     * The prefix range in CIDR notation. Should include the start address and the prefix length.
     */
    private String cidr;

    /*
     * Signed message for WAN validation.
     */
    private String signedMessage;

    /*
     * Authorization message for WAN validation.
     */
    private String authorizationMessage;

    /*
     * The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     */
    private SubResource customIpPrefixParent;

    /*
     * The list of all Children for IPv6 /48 CustomIpPrefix.
     */
    private List<SubResource> childCustomIpPrefixes;

    /*
     * The commissioned state of the Custom IP Prefix.
     */
    private CommissionedState commissionedState;

    /*
     * Whether to do express route advertise.
     */
    private Boolean expressRouteAdvertise;

    /*
     * The Geo for CIDR advertising. Should be an Geo code.
     */
    private Geo geo;

    /*
     * Whether to Advertise the range to Internet.
     */
    private Boolean noInternetAdvertise;

    /*
     * Type of custom IP prefix. Should be Singular, Parent, or Child.
     */
    private CustomIpPrefixType prefixType;

    /*
     * The list of all referenced PublicIpPrefixes.
     */
    private List<SubResource> publicIpPrefixes;

    /*
     * The resource GUID property of the custom IP prefix resource.
     */
    private String resourceGuid;

    /*
     * The reason why resource is in failed state.
     */
    private String failedReason;

    /*
     * The provisioning state of the custom IP prefix resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of CustomIpPrefixPropertiesFormat class.
     */
    public CustomIpPrefixPropertiesFormat() {
    }

    /**
     * Get the asn property: The ASN for CIDR advertising. Should be an integer as string.
     * 
     * @return the asn value.
     */
    public String asn() {
        return this.asn;
    }

    /**
     * Set the asn property: The ASN for CIDR advertising. Should be an integer as string.
     * 
     * @param asn the asn value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withAsn(String asn) {
        this.asn = asn;
        return this;
    }

    /**
     * Get the cidr property: The prefix range in CIDR notation. Should include the start address and the prefix length.
     * 
     * @return the cidr value.
     */
    public String cidr() {
        return this.cidr;
    }

    /**
     * Set the cidr property: The prefix range in CIDR notation. Should include the start address and the prefix length.
     * 
     * @param cidr the cidr value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    /**
     * Get the signedMessage property: Signed message for WAN validation.
     * 
     * @return the signedMessage value.
     */
    public String signedMessage() {
        return this.signedMessage;
    }

    /**
     * Set the signedMessage property: Signed message for WAN validation.
     * 
     * @param signedMessage the signedMessage value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withSignedMessage(String signedMessage) {
        this.signedMessage = signedMessage;
        return this;
    }

    /**
     * Get the authorizationMessage property: Authorization message for WAN validation.
     * 
     * @return the authorizationMessage value.
     */
    public String authorizationMessage() {
        return this.authorizationMessage;
    }

    /**
     * Set the authorizationMessage property: Authorization message for WAN validation.
     * 
     * @param authorizationMessage the authorizationMessage value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withAuthorizationMessage(String authorizationMessage) {
        this.authorizationMessage = authorizationMessage;
        return this;
    }

    /**
     * Get the customIpPrefixParent property: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     * 
     * @return the customIpPrefixParent value.
     */
    public SubResource customIpPrefixParent() {
        return this.customIpPrefixParent;
    }

    /**
     * Set the customIpPrefixParent property: The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
     * 
     * @param customIpPrefixParent the customIpPrefixParent value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCustomIpPrefixParent(SubResource customIpPrefixParent) {
        this.customIpPrefixParent = customIpPrefixParent;
        return this;
    }

    /**
     * Get the childCustomIpPrefixes property: The list of all Children for IPv6 /48 CustomIpPrefix.
     * 
     * @return the childCustomIpPrefixes value.
     */
    public List<SubResource> childCustomIpPrefixes() {
        return this.childCustomIpPrefixes;
    }

    /**
     * Get the commissionedState property: The commissioned state of the Custom IP Prefix.
     * 
     * @return the commissionedState value.
     */
    public CommissionedState commissionedState() {
        return this.commissionedState;
    }

    /**
     * Set the commissionedState property: The commissioned state of the Custom IP Prefix.
     * 
     * @param commissionedState the commissionedState value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withCommissionedState(CommissionedState commissionedState) {
        this.commissionedState = commissionedState;
        return this;
    }

    /**
     * Get the expressRouteAdvertise property: Whether to do express route advertise.
     * 
     * @return the expressRouteAdvertise value.
     */
    public Boolean expressRouteAdvertise() {
        return this.expressRouteAdvertise;
    }

    /**
     * Set the expressRouteAdvertise property: Whether to do express route advertise.
     * 
     * @param expressRouteAdvertise the expressRouteAdvertise value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withExpressRouteAdvertise(Boolean expressRouteAdvertise) {
        this.expressRouteAdvertise = expressRouteAdvertise;
        return this;
    }

    /**
     * Get the geo property: The Geo for CIDR advertising. Should be an Geo code.
     * 
     * @return the geo value.
     */
    public Geo geo() {
        return this.geo;
    }

    /**
     * Set the geo property: The Geo for CIDR advertising. Should be an Geo code.
     * 
     * @param geo the geo value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withGeo(Geo geo) {
        this.geo = geo;
        return this;
    }

    /**
     * Get the noInternetAdvertise property: Whether to Advertise the range to Internet.
     * 
     * @return the noInternetAdvertise value.
     */
    public Boolean noInternetAdvertise() {
        return this.noInternetAdvertise;
    }

    /**
     * Set the noInternetAdvertise property: Whether to Advertise the range to Internet.
     * 
     * @param noInternetAdvertise the noInternetAdvertise value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withNoInternetAdvertise(Boolean noInternetAdvertise) {
        this.noInternetAdvertise = noInternetAdvertise;
        return this;
    }

    /**
     * Get the prefixType property: Type of custom IP prefix. Should be Singular, Parent, or Child.
     * 
     * @return the prefixType value.
     */
    public CustomIpPrefixType prefixType() {
        return this.prefixType;
    }

    /**
     * Set the prefixType property: Type of custom IP prefix. Should be Singular, Parent, or Child.
     * 
     * @param prefixType the prefixType value to set.
     * @return the CustomIpPrefixPropertiesFormat object itself.
     */
    public CustomIpPrefixPropertiesFormat withPrefixType(CustomIpPrefixType prefixType) {
        this.prefixType = prefixType;
        return this;
    }

    /**
     * Get the publicIpPrefixes property: The list of all referenced PublicIpPrefixes.
     * 
     * @return the publicIpPrefixes value.
     */
    public List<SubResource> publicIpPrefixes() {
        return this.publicIpPrefixes;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the custom IP prefix resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the failedReason property: The reason why resource is in failed state.
     * 
     * @return the failedReason value.
     */
    public String failedReason() {
        return this.failedReason;
    }

    /**
     * Get the provisioningState property: The provisioning state of the custom IP prefix resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("asn", this.asn);
        jsonWriter.writeStringField("cidr", this.cidr);
        jsonWriter.writeStringField("signedMessage", this.signedMessage);
        jsonWriter.writeStringField("authorizationMessage", this.authorizationMessage);
        jsonWriter.writeJsonField("customIpPrefixParent", this.customIpPrefixParent);
        jsonWriter.writeStringField("commissionedState",
            this.commissionedState == null ? null : this.commissionedState.toString());
        jsonWriter.writeBooleanField("expressRouteAdvertise", this.expressRouteAdvertise);
        jsonWriter.writeStringField("geo", this.geo == null ? null : this.geo.toString());
        jsonWriter.writeBooleanField("noInternetAdvertise", this.noInternetAdvertise);
        jsonWriter.writeStringField("prefixType", this.prefixType == null ? null : this.prefixType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomIpPrefixPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomIpPrefixPropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomIpPrefixPropertiesFormat.
     */
    public static CustomIpPrefixPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomIpPrefixPropertiesFormat deserializedCustomIpPrefixPropertiesFormat
                = new CustomIpPrefixPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("asn".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.asn = reader.getString();
                } else if ("cidr".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.cidr = reader.getString();
                } else if ("signedMessage".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.signedMessage = reader.getString();
                } else if ("authorizationMessage".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.authorizationMessage = reader.getString();
                } else if ("customIpPrefixParent".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.customIpPrefixParent = SubResource.fromJson(reader);
                } else if ("childCustomIpPrefixes".equals(fieldName)) {
                    List<SubResource> childCustomIpPrefixes
                        = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedCustomIpPrefixPropertiesFormat.childCustomIpPrefixes = childCustomIpPrefixes;
                } else if ("commissionedState".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.commissionedState
                        = CommissionedState.fromString(reader.getString());
                } else if ("expressRouteAdvertise".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.expressRouteAdvertise
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("geo".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.geo = Geo.fromString(reader.getString());
                } else if ("noInternetAdvertise".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.noInternetAdvertise
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("prefixType".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.prefixType
                        = CustomIpPrefixType.fromString(reader.getString());
                } else if ("publicIpPrefixes".equals(fieldName)) {
                    List<SubResource> publicIpPrefixes = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedCustomIpPrefixPropertiesFormat.publicIpPrefixes = publicIpPrefixes;
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.resourceGuid = reader.getString();
                } else if ("failedReason".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.failedReason = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCustomIpPrefixPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomIpPrefixPropertiesFormat;
        });
    }
}
