// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The information of an AutoApprovedPrivateLinkService.
 */
@Fluent
public final class AutoApprovedPrivateLinkServiceInner
    implements JsonSerializable<AutoApprovedPrivateLinkServiceInner> {
    /*
     * The id of the private link service resource.
     */
    private String privateLinkService;

    /**
     * Creates an instance of AutoApprovedPrivateLinkServiceInner class.
     */
    public AutoApprovedPrivateLinkServiceInner() {
    }

    /**
     * Get the privateLinkService property: The id of the private link service resource.
     * 
     * @return the privateLinkService value.
     */
    public String privateLinkService() {
        return this.privateLinkService;
    }

    /**
     * Set the privateLinkService property: The id of the private link service resource.
     * 
     * @param privateLinkService the privateLinkService value to set.
     * @return the AutoApprovedPrivateLinkServiceInner object itself.
     */
    public AutoApprovedPrivateLinkServiceInner withPrivateLinkService(String privateLinkService) {
        this.privateLinkService = privateLinkService;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateLinkService", this.privateLinkService);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoApprovedPrivateLinkServiceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoApprovedPrivateLinkServiceInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoApprovedPrivateLinkServiceInner.
     */
    public static AutoApprovedPrivateLinkServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoApprovedPrivateLinkServiceInner deserializedAutoApprovedPrivateLinkServiceInner
                = new AutoApprovedPrivateLinkServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateLinkService".equals(fieldName)) {
                    deserializedAutoApprovedPrivateLinkServiceInner.privateLinkService = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoApprovedPrivateLinkServiceInner;
        });
    }
}
