// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayFirewallManifestRuleSet;
import java.io.IOException;
import java.util.List;

/**
 * Properties of ApplicationGatewayWafDynamicManifest.
 */
@Fluent
public final class ApplicationGatewayWafDynamicManifestPropertiesResult
    implements JsonSerializable<ApplicationGatewayWafDynamicManifestPropertiesResult> {
    /*
     * The default ruleset.
     */
    private DefaultRuleSetPropertyFormat innerDefaultRuleSet;

    /*
     * The available rulesets.
     */
    private List<ApplicationGatewayFirewallManifestRuleSet> availableRuleSets;

    /**
     * Creates an instance of ApplicationGatewayWafDynamicManifestPropertiesResult class.
     */
    public ApplicationGatewayWafDynamicManifestPropertiesResult() {
    }

    /**
     * Get the innerDefaultRuleSet property: The default ruleset.
     * 
     * @return the innerDefaultRuleSet value.
     */
    private DefaultRuleSetPropertyFormat innerDefaultRuleSet() {
        return this.innerDefaultRuleSet;
    }

    /**
     * Get the availableRuleSets property: The available rulesets.
     * 
     * @return the availableRuleSets value.
     */
    public List<ApplicationGatewayFirewallManifestRuleSet> availableRuleSets() {
        return this.availableRuleSets;
    }

    /**
     * Set the availableRuleSets property: The available rulesets.
     * 
     * @param availableRuleSets the availableRuleSets value to set.
     * @return the ApplicationGatewayWafDynamicManifestPropertiesResult object itself.
     */
    public ApplicationGatewayWafDynamicManifestPropertiesResult
        withAvailableRuleSets(List<ApplicationGatewayFirewallManifestRuleSet> availableRuleSets) {
        this.availableRuleSets = availableRuleSets;
        return this;
    }

    /**
     * Get the ruleSetType property: The type of the web application firewall rule set.
     * 
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.innerDefaultRuleSet() == null ? null : this.innerDefaultRuleSet().ruleSetType();
    }

    /**
     * Set the ruleSetType property: The type of the web application firewall rule set.
     * 
     * @param ruleSetType the ruleSetType value to set.
     * @return the ApplicationGatewayWafDynamicManifestPropertiesResult object itself.
     */
    public ApplicationGatewayWafDynamicManifestPropertiesResult withRuleSetType(String ruleSetType) {
        if (this.innerDefaultRuleSet() == null) {
            this.innerDefaultRuleSet = new DefaultRuleSetPropertyFormat();
        }
        this.innerDefaultRuleSet().withRuleSetType(ruleSetType);
        return this;
    }

    /**
     * Get the ruleSetVersion property: The version of the web application firewall rule set type.
     * 
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.innerDefaultRuleSet() == null ? null : this.innerDefaultRuleSet().ruleSetVersion();
    }

    /**
     * Set the ruleSetVersion property: The version of the web application firewall rule set type.
     * 
     * @param ruleSetVersion the ruleSetVersion value to set.
     * @return the ApplicationGatewayWafDynamicManifestPropertiesResult object itself.
     */
    public ApplicationGatewayWafDynamicManifestPropertiesResult withRuleSetVersion(String ruleSetVersion) {
        if (this.innerDefaultRuleSet() == null) {
            this.innerDefaultRuleSet = new DefaultRuleSetPropertyFormat();
        }
        this.innerDefaultRuleSet().withRuleSetVersion(ruleSetVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerDefaultRuleSet() != null) {
            innerDefaultRuleSet().validate();
        }
        if (availableRuleSets() != null) {
            availableRuleSets().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("defaultRuleSet", this.innerDefaultRuleSet);
        jsonWriter.writeArrayField("availableRuleSets", this.availableRuleSets,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayWafDynamicManifestPropertiesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayWafDynamicManifestPropertiesResult if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayWafDynamicManifestPropertiesResult.
     */
    public static ApplicationGatewayWafDynamicManifestPropertiesResult fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayWafDynamicManifestPropertiesResult deserializedApplicationGatewayWafDynamicManifestPropertiesResult
                = new ApplicationGatewayWafDynamicManifestPropertiesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultRuleSet".equals(fieldName)) {
                    deserializedApplicationGatewayWafDynamicManifestPropertiesResult.innerDefaultRuleSet
                        = DefaultRuleSetPropertyFormat.fromJson(reader);
                } else if ("availableRuleSets".equals(fieldName)) {
                    List<ApplicationGatewayFirewallManifestRuleSet> availableRuleSets
                        = reader.readArray(reader1 -> ApplicationGatewayFirewallManifestRuleSet.fromJson(reader1));
                    deserializedApplicationGatewayWafDynamicManifestPropertiesResult.availableRuleSets
                        = availableRuleSets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayWafDynamicManifestPropertiesResult;
        });
    }
}
