// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCipherSuite;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslProtocol;
import java.io.IOException;
import java.util.List;

/**
 * Properties of ApplicationGatewaySslPredefinedPolicy.
 */
@Fluent
public final class ApplicationGatewaySslPredefinedPolicyPropertiesFormat
    implements JsonSerializable<ApplicationGatewaySslPredefinedPolicyPropertiesFormat> {
    /*
     * Ssl cipher suites to be enabled in the specified order for application gateway.
     */
    private List<ApplicationGatewaySslCipherSuite> cipherSuites;

    /*
     * Minimum version of Ssl protocol to be supported on application gateway.
     */
    private ApplicationGatewaySslProtocol minProtocolVersion;

    /**
     * Creates an instance of ApplicationGatewaySslPredefinedPolicyPropertiesFormat class.
     */
    public ApplicationGatewaySslPredefinedPolicyPropertiesFormat() {
    }

    /**
     * Get the cipherSuites property: Ssl cipher suites to be enabled in the specified order for application gateway.
     * 
     * @return the cipherSuites value.
     */
    public List<ApplicationGatewaySslCipherSuite> cipherSuites() {
        return this.cipherSuites;
    }

    /**
     * Set the cipherSuites property: Ssl cipher suites to be enabled in the specified order for application gateway.
     * 
     * @param cipherSuites the cipherSuites value to set.
     * @return the ApplicationGatewaySslPredefinedPolicyPropertiesFormat object itself.
     */
    public ApplicationGatewaySslPredefinedPolicyPropertiesFormat
        withCipherSuites(List<ApplicationGatewaySslCipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
        return this;
    }

    /**
     * Get the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @return the minProtocolVersion value.
     */
    public ApplicationGatewaySslProtocol minProtocolVersion() {
        return this.minProtocolVersion;
    }

    /**
     * Set the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @param minProtocolVersion the minProtocolVersion value to set.
     * @return the ApplicationGatewaySslPredefinedPolicyPropertiesFormat object itself.
     */
    public ApplicationGatewaySslPredefinedPolicyPropertiesFormat
        withMinProtocolVersion(ApplicationGatewaySslProtocol minProtocolVersion) {
        this.minProtocolVersion = minProtocolVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("cipherSuites", this.cipherSuites,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("minProtocolVersion",
            this.minProtocolVersion == null ? null : this.minProtocolVersion.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewaySslPredefinedPolicyPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewaySslPredefinedPolicyPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewaySslPredefinedPolicyPropertiesFormat.
     */
    public static ApplicationGatewaySslPredefinedPolicyPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewaySslPredefinedPolicyPropertiesFormat deserializedApplicationGatewaySslPredefinedPolicyPropertiesFormat
                = new ApplicationGatewaySslPredefinedPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cipherSuites".equals(fieldName)) {
                    List<ApplicationGatewaySslCipherSuite> cipherSuites
                        = reader.readArray(reader1 -> ApplicationGatewaySslCipherSuite.fromString(reader1.getString()));
                    deserializedApplicationGatewaySslPredefinedPolicyPropertiesFormat.cipherSuites = cipherSuites;
                } else if ("minProtocolVersion".equals(fieldName)) {
                    deserializedApplicationGatewaySslPredefinedPolicyPropertiesFormat.minProtocolVersion
                        = ApplicationGatewaySslProtocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewaySslPredefinedPolicyPropertiesFormat;
        });
    }
}
