// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectType;
import java.io.IOException;
import java.util.List;

/**
 * Properties of redirect configuration of the application gateway.
 */
@Fluent
public final class ApplicationGatewayRedirectConfigurationPropertiesFormat
    implements JsonSerializable<ApplicationGatewayRedirectConfigurationPropertiesFormat> {
    /*
     * HTTP redirection type.
     */
    private ApplicationGatewayRedirectType redirectType;

    /*
     * Reference to a listener to redirect the request to.
     */
    private SubResource targetListener;

    /*
     * Url to redirect the request to.
     */
    private String targetUrl;

    /*
     * Include path in the redirected url.
     */
    private Boolean includePath;

    /*
     * Include query string in the redirected url.
     */
    private Boolean includeQueryString;

    /*
     * Request routing specifying redirect configuration.
     */
    private List<SubResource> requestRoutingRules;

    /*
     * Url path maps specifying default redirect configuration.
     */
    private List<SubResource> urlPathMaps;

    /*
     * Path rules specifying redirect configuration.
     */
    private List<SubResource> pathRules;

    /**
     * Creates an instance of ApplicationGatewayRedirectConfigurationPropertiesFormat class.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat() {
    }

    /**
     * Get the redirectType property: HTTP redirection type.
     * 
     * @return the redirectType value.
     */
    public ApplicationGatewayRedirectType redirectType() {
        return this.redirectType;
    }

    /**
     * Set the redirectType property: HTTP redirection type.
     * 
     * @param redirectType the redirectType value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat
        withRedirectType(ApplicationGatewayRedirectType redirectType) {
        this.redirectType = redirectType;
        return this;
    }

    /**
     * Get the targetListener property: Reference to a listener to redirect the request to.
     * 
     * @return the targetListener value.
     */
    public SubResource targetListener() {
        return this.targetListener;
    }

    /**
     * Set the targetListener property: Reference to a listener to redirect the request to.
     * 
     * @param targetListener the targetListener value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withTargetListener(SubResource targetListener) {
        this.targetListener = targetListener;
        return this;
    }

    /**
     * Get the targetUrl property: Url to redirect the request to.
     * 
     * @return the targetUrl value.
     */
    public String targetUrl() {
        return this.targetUrl;
    }

    /**
     * Set the targetUrl property: Url to redirect the request to.
     * 
     * @param targetUrl the targetUrl value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
        return this;
    }

    /**
     * Get the includePath property: Include path in the redirected url.
     * 
     * @return the includePath value.
     */
    public Boolean includePath() {
        return this.includePath;
    }

    /**
     * Set the includePath property: Include path in the redirected url.
     * 
     * @param includePath the includePath value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withIncludePath(Boolean includePath) {
        this.includePath = includePath;
        return this;
    }

    /**
     * Get the includeQueryString property: Include query string in the redirected url.
     * 
     * @return the includeQueryString value.
     */
    public Boolean includeQueryString() {
        return this.includeQueryString;
    }

    /**
     * Set the includeQueryString property: Include query string in the redirected url.
     * 
     * @param includeQueryString the includeQueryString value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withIncludeQueryString(Boolean includeQueryString) {
        this.includeQueryString = includeQueryString;
        return this;
    }

    /**
     * Get the requestRoutingRules property: Request routing specifying redirect configuration.
     * 
     * @return the requestRoutingRules value.
     */
    public List<SubResource> requestRoutingRules() {
        return this.requestRoutingRules;
    }

    /**
     * Set the requestRoutingRules property: Request routing specifying redirect configuration.
     * 
     * @param requestRoutingRules the requestRoutingRules value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat
        withRequestRoutingRules(List<SubResource> requestRoutingRules) {
        this.requestRoutingRules = requestRoutingRules;
        return this;
    }

    /**
     * Get the urlPathMaps property: Url path maps specifying default redirect configuration.
     * 
     * @return the urlPathMaps value.
     */
    public List<SubResource> urlPathMaps() {
        return this.urlPathMaps;
    }

    /**
     * Set the urlPathMaps property: Url path maps specifying default redirect configuration.
     * 
     * @param urlPathMaps the urlPathMaps value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withUrlPathMaps(List<SubResource> urlPathMaps) {
        this.urlPathMaps = urlPathMaps;
        return this;
    }

    /**
     * Get the pathRules property: Path rules specifying redirect configuration.
     * 
     * @return the pathRules value.
     */
    public List<SubResource> pathRules() {
        return this.pathRules;
    }

    /**
     * Set the pathRules property: Path rules specifying redirect configuration.
     * 
     * @param pathRules the pathRules value to set.
     * @return the ApplicationGatewayRedirectConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayRedirectConfigurationPropertiesFormat withPathRules(List<SubResource> pathRules) {
        this.pathRules = pathRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("redirectType", this.redirectType == null ? null : this.redirectType.toString());
        jsonWriter.writeJsonField("targetListener", this.targetListener);
        jsonWriter.writeStringField("targetUrl", this.targetUrl);
        jsonWriter.writeBooleanField("includePath", this.includePath);
        jsonWriter.writeBooleanField("includeQueryString", this.includeQueryString);
        jsonWriter.writeArrayField("requestRoutingRules", this.requestRoutingRules,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("urlPathMaps", this.urlPathMaps, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("pathRules", this.pathRules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayRedirectConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayRedirectConfigurationPropertiesFormat if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayRedirectConfigurationPropertiesFormat.
     */
    public static ApplicationGatewayRedirectConfigurationPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayRedirectConfigurationPropertiesFormat deserializedApplicationGatewayRedirectConfigurationPropertiesFormat
                = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("redirectType".equals(fieldName)) {
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.redirectType
                        = ApplicationGatewayRedirectType.fromString(reader.getString());
                } else if ("targetListener".equals(fieldName)) {
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.targetListener
                        = SubResource.fromJson(reader);
                } else if ("targetUrl".equals(fieldName)) {
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.targetUrl = reader.getString();
                } else if ("includePath".equals(fieldName)) {
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.includePath
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeQueryString".equals(fieldName)) {
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.includeQueryString
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("requestRoutingRules".equals(fieldName)) {
                    List<SubResource> requestRoutingRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.requestRoutingRules
                        = requestRoutingRules;
                } else if ("urlPathMaps".equals(fieldName)) {
                    List<SubResource> urlPathMaps = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.urlPathMaps = urlPathMaps;
                } else if ("pathRules".equals(fieldName)) {
                    List<SubResource> pathRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedApplicationGatewayRedirectConfigurationPropertiesFormat.pathRules = pathRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayRedirectConfigurationPropertiesFormat;
        });
    }
}
