// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of Private Link Resource of an application gateway.
 */
@Fluent
public final class ApplicationGatewayPrivateEndpointConnectionPropertiesInner
    implements JsonSerializable<ApplicationGatewayPrivateEndpointConnectionPropertiesInner> {
    /*
     * The resource of private end point.
     */
    private PrivateEndpointInner privateEndpoint;

    /*
     * A collection of information about the state of the connection between service consumer and provider.
     */
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;

    /*
     * The provisioning state of the application gateway private endpoint connection resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The consumer link id.
     */
    private String linkIdentifier;

    /**
     * Creates an instance of ApplicationGatewayPrivateEndpointConnectionPropertiesInner class.
     */
    public ApplicationGatewayPrivateEndpointConnectionPropertiesInner() {
    }

    /**
     * Get the privateEndpoint property: The resource of private end point.
     * 
     * @return the privateEndpoint value.
     */
    public PrivateEndpointInner privateEndpoint() {
        return this.privateEndpoint;
    }

    /**
     * Get the privateLinkServiceConnectionState property: A collection of information about the state of the connection
     * between service consumer and provider.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    /**
     * Set the privateLinkServiceConnectionState property: A collection of information about the state of the connection
     * between service consumer and provider.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the ApplicationGatewayPrivateEndpointConnectionPropertiesInner object itself.
     */
    public ApplicationGatewayPrivateEndpointConnectionPropertiesInner
        withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the application gateway private endpoint connection
     * resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the linkIdentifier property: The consumer link id.
     * 
     * @return the linkIdentifier value.
     */
    public String linkIdentifier() {
        return this.linkIdentifier;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privateEndpoint() != null) {
            privateEndpoint().validate();
        }
        if (privateLinkServiceConnectionState() != null) {
            privateLinkServiceConnectionState().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayPrivateEndpointConnectionPropertiesInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayPrivateEndpointConnectionPropertiesInner if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayPrivateEndpointConnectionPropertiesInner.
     */
    public static ApplicationGatewayPrivateEndpointConnectionPropertiesInner fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateEndpointConnectionPropertiesInner deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner
                = new ApplicationGatewayPrivateEndpointConnectionPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privateEndpoint".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner.privateEndpoint
                        = PrivateEndpointInner.fromJson(reader);
                } else if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner.privateLinkServiceConnectionState
                        = PrivateLinkServiceConnectionState.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("linkIdentifier".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner.linkIdentifier
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayPrivateEndpointConnectionPropertiesInner;
        });
    }
}
