// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Properties of Frontend port of an application gateway.
 */
@Fluent
public final class ApplicationGatewayFrontendPortPropertiesFormat
    implements JsonSerializable<ApplicationGatewayFrontendPortPropertiesFormat> {
    /*
     * Frontend port.
     */
    private Integer port;

    /*
     * The provisioning state of the frontend port resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayFrontendPortPropertiesFormat class.
     */
    public ApplicationGatewayFrontendPortPropertiesFormat() {
    }

    /**
     * Get the port property: Frontend port.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Frontend port.
     * 
     * @param port the port value to set.
     * @return the ApplicationGatewayFrontendPortPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendPortPropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend port resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", this.port);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayFrontendPortPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayFrontendPortPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayFrontendPortPropertiesFormat.
     */
    public static ApplicationGatewayFrontendPortPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFrontendPortPropertiesFormat deserializedApplicationGatewayFrontendPortPropertiesFormat
                = new ApplicationGatewayFrontendPortPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("port".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendPortPropertiesFormat.port
                        = reader.getNullable(JsonReader::getInt);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayFrontendPortPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayFrontendPortPropertiesFormat;
        });
    }
}
