// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthServerHealth;
import java.io.IOException;

/**
 * Application gateway backendhealth http settings.
 */
@Fluent
public final class ApplicationGatewayBackendHealthServerInner
    implements JsonSerializable<ApplicationGatewayBackendHealthServerInner> {
    /*
     * IP address or FQDN of backend server.
     */
    private String address;

    /*
     * Reference to IP configuration of backend server.
     */
    private NetworkInterfaceIpConfigurationInner ipConfiguration;

    /*
     * Health of backend server.
     */
    private ApplicationGatewayBackendHealthServerHealth health;

    /*
     * Health Probe Log.
     */
    private String healthProbeLog;

    /**
     * Creates an instance of ApplicationGatewayBackendHealthServerInner class.
     */
    public ApplicationGatewayBackendHealthServerInner() {
    }

    /**
     * Get the address property: IP address or FQDN of backend server.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: IP address or FQDN of backend server.
     * 
     * @param address the address value to set.
     * @return the ApplicationGatewayBackendHealthServerInner object itself.
     */
    public ApplicationGatewayBackendHealthServerInner withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the ipConfiguration property: Reference to IP configuration of backend server.
     * 
     * @return the ipConfiguration value.
     */
    public NetworkInterfaceIpConfigurationInner ipConfiguration() {
        return this.ipConfiguration;
    }

    /**
     * Set the ipConfiguration property: Reference to IP configuration of backend server.
     * 
     * @param ipConfiguration the ipConfiguration value to set.
     * @return the ApplicationGatewayBackendHealthServerInner object itself.
     */
    public ApplicationGatewayBackendHealthServerInner
        withIpConfiguration(NetworkInterfaceIpConfigurationInner ipConfiguration) {
        this.ipConfiguration = ipConfiguration;
        return this;
    }

    /**
     * Get the health property: Health of backend server.
     * 
     * @return the health value.
     */
    public ApplicationGatewayBackendHealthServerHealth health() {
        return this.health;
    }

    /**
     * Set the health property: Health of backend server.
     * 
     * @param health the health value to set.
     * @return the ApplicationGatewayBackendHealthServerInner object itself.
     */
    public ApplicationGatewayBackendHealthServerInner withHealth(ApplicationGatewayBackendHealthServerHealth health) {
        this.health = health;
        return this;
    }

    /**
     * Get the healthProbeLog property: Health Probe Log.
     * 
     * @return the healthProbeLog value.
     */
    public String healthProbeLog() {
        return this.healthProbeLog;
    }

    /**
     * Set the healthProbeLog property: Health Probe Log.
     * 
     * @param healthProbeLog the healthProbeLog value to set.
     * @return the ApplicationGatewayBackendHealthServerInner object itself.
     */
    public ApplicationGatewayBackendHealthServerInner withHealthProbeLog(String healthProbeLog) {
        this.healthProbeLog = healthProbeLog;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfiguration() != null) {
            ipConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeJsonField("ipConfiguration", this.ipConfiguration);
        jsonWriter.writeStringField("health", this.health == null ? null : this.health.toString());
        jsonWriter.writeStringField("healthProbeLog", this.healthProbeLog);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendHealthServerInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendHealthServerInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendHealthServerInner.
     */
    public static ApplicationGatewayBackendHealthServerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthServerInner deserializedApplicationGatewayBackendHealthServerInner
                = new ApplicationGatewayBackendHealthServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.address = reader.getString();
                } else if ("ipConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.ipConfiguration
                        = NetworkInterfaceIpConfigurationInner.fromJson(reader);
                } else if ("health".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.health
                        = ApplicationGatewayBackendHealthServerHealth.fromString(reader.getString());
                } else if ("healthProbeLog".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthServerInner.healthProbeLog = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendHealthServerInner;
        });
    }
}
