/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionPeeringInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCrossConnectionProperties;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitReference;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.ServiceProviderProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ExpressRouteCrossConnectionInner
extends Resource {
    @JsonProperty(value="properties")
    private ExpressRouteCrossConnectionProperties innerProperties;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="id")
    private String id;

    private ExpressRouteCrossConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public String id() {
        return this.id;
    }

    public ExpressRouteCrossConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    public ExpressRouteCrossConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ExpressRouteCrossConnectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    public Integer stag() {
        return this.innerProperties() == null ? null : this.innerProperties().stag();
    }

    public String peeringLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringLocation();
    }

    public Integer bandwidthInMbps() {
        return this.innerProperties() == null ? null : this.innerProperties().bandwidthInMbps();
    }

    public ExpressRouteCircuitReference expressRouteCircuit() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteCircuit();
    }

    public ExpressRouteCrossConnectionInner withExpressRouteCircuit(ExpressRouteCircuitReference expressRouteCircuit) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withExpressRouteCircuit(expressRouteCircuit);
        return this;
    }

    public ServiceProviderProvisioningState serviceProviderProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderProvisioningState();
    }

    public ExpressRouteCrossConnectionInner withServiceProviderProvisioningState(ServiceProviderProvisioningState serviceProviderProvisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withServiceProviderProvisioningState(serviceProviderProvisioningState);
        return this;
    }

    public String serviceProviderNotes() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceProviderNotes();
    }

    public ExpressRouteCrossConnectionInner withServiceProviderNotes(String serviceProviderNotes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withServiceProviderNotes(serviceProviderNotes);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ExpressRouteCrossConnectionPeeringInner> peerings() {
        return this.innerProperties() == null ? null : this.innerProperties().peerings();
    }

    public ExpressRouteCrossConnectionInner withPeerings(List<ExpressRouteCrossConnectionPeeringInner> peerings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCrossConnectionProperties();
        }
        this.innerProperties().withPeerings(peerings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

