// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Specifies slot info on a cloud service. */
public enum SlotType {
    /** Enum value Production. */
    PRODUCTION("Production"),

    /** Enum value Staging. */
    STAGING("Staging");

    /** The actual serialized value for a SlotType instance. */
    private final String value;

    SlotType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SlotType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed SlotType object, or null if unable to parse.
     */
    @JsonCreator
    public static SlotType fromString(String value) {
        if (value == null) {
            return null;
        }
        SlotType[] items = SlotType.values();
        for (SlotType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
