// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Log Analytics Workspace for Firewall Policy Insights. */
@Fluent
public final class FirewallPolicyLogAnalyticsWorkspace {
    /*
     * Region to configure the Workspace.
     */
    @JsonProperty(value = "region")
    private String region;

    /*
     * The workspace Id for Firewall Policy Insights.
     */
    @JsonProperty(value = "workspaceId")
    private SubResource workspaceId;

    /** Creates an instance of FirewallPolicyLogAnalyticsWorkspace class. */
    public FirewallPolicyLogAnalyticsWorkspace() {
    }

    /**
     * Get the region property: Region to configure the Workspace.
     *
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: Region to configure the Workspace.
     *
     * @param region the region value to set.
     * @return the FirewallPolicyLogAnalyticsWorkspace object itself.
     */
    public FirewallPolicyLogAnalyticsWorkspace withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the workspaceId property: The workspace Id for Firewall Policy Insights.
     *
     * @return the workspaceId value.
     */
    public SubResource workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set the workspaceId property: The workspace Id for Firewall Policy Insights.
     *
     * @param workspaceId the workspaceId value to set.
     * @return the FirewallPolicyLogAnalyticsWorkspace object itself.
     */
    public FirewallPolicyLogAnalyticsWorkspace withWorkspaceId(SubResource workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
