// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Connectivity group item. */
@Fluent
public final class ConnectivityGroupItem {
    /*
     * Network group Id.
     */
    @JsonProperty(value = "networkGroupId", required = true)
    private String networkGroupId;

    /*
     * Flag if need to use hub gateway.
     */
    @JsonProperty(value = "useHubGateway")
    private UseHubGateway useHubGateway;

    /*
     * Flag if global is supported.
     */
    @JsonProperty(value = "isGlobal")
    private IsGlobal isGlobal;

    /*
     * Group connectivity type.
     */
    @JsonProperty(value = "groupConnectivity", required = true)
    private GroupConnectivity groupConnectivity;

    /** Creates an instance of ConnectivityGroupItem class. */
    public ConnectivityGroupItem() {
    }

    /**
     * Get the networkGroupId property: Network group Id.
     *
     * @return the networkGroupId value.
     */
    public String networkGroupId() {
        return this.networkGroupId;
    }

    /**
     * Set the networkGroupId property: Network group Id.
     *
     * @param networkGroupId the networkGroupId value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withNetworkGroupId(String networkGroupId) {
        this.networkGroupId = networkGroupId;
        return this;
    }

    /**
     * Get the useHubGateway property: Flag if need to use hub gateway.
     *
     * @return the useHubGateway value.
     */
    public UseHubGateway useHubGateway() {
        return this.useHubGateway;
    }

    /**
     * Set the useHubGateway property: Flag if need to use hub gateway.
     *
     * @param useHubGateway the useHubGateway value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withUseHubGateway(UseHubGateway useHubGateway) {
        this.useHubGateway = useHubGateway;
        return this;
    }

    /**
     * Get the isGlobal property: Flag if global is supported.
     *
     * @return the isGlobal value.
     */
    public IsGlobal isGlobal() {
        return this.isGlobal;
    }

    /**
     * Set the isGlobal property: Flag if global is supported.
     *
     * @param isGlobal the isGlobal value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withIsGlobal(IsGlobal isGlobal) {
        this.isGlobal = isGlobal;
        return this;
    }

    /**
     * Get the groupConnectivity property: Group connectivity type.
     *
     * @return the groupConnectivity value.
     */
    public GroupConnectivity groupConnectivity() {
        return this.groupConnectivity;
    }

    /**
     * Set the groupConnectivity property: Group connectivity type.
     *
     * @param groupConnectivity the groupConnectivity value to set.
     * @return the ConnectivityGroupItem object itself.
     */
    public ConnectivityGroupItem withGroupConnectivity(GroupConnectivity groupConnectivity) {
        this.groupConnectivity = groupConnectivity;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkGroupId() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property networkGroupId in model ConnectivityGroupItem"));
        }
        if (groupConnectivity() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property groupConnectivity in model ConnectivityGroupItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ConnectivityGroupItem.class);
}
