// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubRouteV2;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters for VirtualHubRouteTableV2. */
@Fluent
public final class VirtualHubRouteTableV2Properties {
    /*
     * List of all routes.
     */
    @JsonProperty(value = "routes")
    private List<VirtualHubRouteV2> routes;

    /*
     * List of all connections attached to this route table v2.
     */
    @JsonProperty(value = "attachedConnections")
    private List<String> attachedConnections;

    /*
     * The provisioning state of the virtual hub route table v2 resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /** Creates an instance of VirtualHubRouteTableV2Properties class. */
    public VirtualHubRouteTableV2Properties() {
    }

    /**
     * Get the routes property: List of all routes.
     *
     * @return the routes value.
     */
    public List<VirtualHubRouteV2> routes() {
        return this.routes;
    }

    /**
     * Set the routes property: List of all routes.
     *
     * @param routes the routes value to set.
     * @return the VirtualHubRouteTableV2Properties object itself.
     */
    public VirtualHubRouteTableV2Properties withRoutes(List<VirtualHubRouteV2> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the attachedConnections property: List of all connections attached to this route table v2.
     *
     * @return the attachedConnections value.
     */
    public List<String> attachedConnections() {
        return this.attachedConnections;
    }

    /**
     * Set the attachedConnections property: List of all connections attached to this route table v2.
     *
     * @param attachedConnections the attachedConnections value to set.
     * @return the VirtualHubRouteTableV2Properties object itself.
     */
    public VirtualHubRouteTableV2Properties withAttachedConnections(List<String> attachedConnections) {
        this.attachedConnections = attachedConnections;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual hub route table v2 resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().forEach(e -> e.validate());
        }
    }
}
