// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ExpressRouteConnectionId;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringState;
import com.azure.resourcemanager.network.models.ExpressRoutePeeringType;
import com.azure.resourcemanager.network.models.Ipv6ExpressRouteCircuitPeeringConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Peering in an ExpressRouteCircuit resource. */
@Fluent
public final class ExpressRouteCircuitPeeringInner extends SubResource {
    /*
     * Properties of the express route circuit peering.
     */
    @JsonProperty(value = "properties")
    private ExpressRouteCircuitPeeringPropertiesFormatInner innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /** Creates an instance of ExpressRouteCircuitPeeringInner class. */
    public ExpressRouteCircuitPeeringInner() {
    }

    /**
     * Get the innerProperties property: Properties of the express route circuit peering.
     *
     * @return the innerProperties value.
     */
    private ExpressRouteCircuitPeeringPropertiesFormatInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public ExpressRouteCircuitPeeringInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the peeringType property: The peering type.
     *
     * @return the peeringType value.
     */
    public ExpressRoutePeeringType peeringType() {
        return this.innerProperties() == null ? null : this.innerProperties().peeringType();
    }

    /**
     * Set the peeringType property: The peering type.
     *
     * @param peeringType the peeringType value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withPeeringType(ExpressRoutePeeringType peeringType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withPeeringType(peeringType);
        return this;
    }

    /**
     * Get the state property: The peering state.
     *
     * @return the state value.
     */
    public ExpressRoutePeeringState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: The peering state.
     *
     * @param state the state value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withState(ExpressRoutePeeringState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the azureAsn property: The Azure ASN.
     *
     * @return the azureAsn value.
     */
    public Integer azureAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().azureAsn();
    }

    /**
     * Set the azureAsn property: The Azure ASN.
     *
     * @param azureAsn the azureAsn value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withAzureAsn(Integer azureAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withAzureAsn(azureAsn);
        return this;
    }

    /**
     * Get the peerAsn property: The peer ASN.
     *
     * @return the peerAsn value.
     */
    public Long peerAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAsn();
    }

    /**
     * Set the peerAsn property: The peer ASN.
     *
     * @param peerAsn the peerAsn value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withPeerAsn(Long peerAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withPeerAsn(peerAsn);
        return this;
    }

    /**
     * Get the primaryPeerAddressPrefix property: The primary address prefix.
     *
     * @return the primaryPeerAddressPrefix value.
     */
    public String primaryPeerAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryPeerAddressPrefix();
    }

    /**
     * Set the primaryPeerAddressPrefix property: The primary address prefix.
     *
     * @param primaryPeerAddressPrefix the primaryPeerAddressPrefix value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withPrimaryPeerAddressPrefix(String primaryPeerAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withPrimaryPeerAddressPrefix(primaryPeerAddressPrefix);
        return this;
    }

    /**
     * Get the secondaryPeerAddressPrefix property: The secondary address prefix.
     *
     * @return the secondaryPeerAddressPrefix value.
     */
    public String secondaryPeerAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryPeerAddressPrefix();
    }

    /**
     * Set the secondaryPeerAddressPrefix property: The secondary address prefix.
     *
     * @param secondaryPeerAddressPrefix the secondaryPeerAddressPrefix value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withSecondaryPeerAddressPrefix(String secondaryPeerAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withSecondaryPeerAddressPrefix(secondaryPeerAddressPrefix);
        return this;
    }

    /**
     * Get the primaryAzurePort property: The primary port.
     *
     * @return the primaryAzurePort value.
     */
    public String primaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAzurePort();
    }

    /**
     * Set the primaryAzurePort property: The primary port.
     *
     * @param primaryAzurePort the primaryAzurePort value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withPrimaryAzurePort(String primaryAzurePort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withPrimaryAzurePort(primaryAzurePort);
        return this;
    }

    /**
     * Get the secondaryAzurePort property: The secondary port.
     *
     * @return the secondaryAzurePort value.
     */
    public String secondaryAzurePort() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAzurePort();
    }

    /**
     * Set the secondaryAzurePort property: The secondary port.
     *
     * @param secondaryAzurePort the secondaryAzurePort value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withSecondaryAzurePort(String secondaryAzurePort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withSecondaryAzurePort(secondaryAzurePort);
        return this;
    }

    /**
     * Get the sharedKey property: The shared key.
     *
     * @return the sharedKey value.
     */
    public String sharedKey() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedKey();
    }

    /**
     * Set the sharedKey property: The shared key.
     *
     * @param sharedKey the sharedKey value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withSharedKey(String sharedKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withSharedKey(sharedKey);
        return this;
    }

    /**
     * Get the vlanId property: The VLAN ID.
     *
     * @return the vlanId value.
     */
    public Integer vlanId() {
        return this.innerProperties() == null ? null : this.innerProperties().vlanId();
    }

    /**
     * Set the vlanId property: The VLAN ID.
     *
     * @param vlanId the vlanId value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withVlanId(Integer vlanId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withVlanId(vlanId);
        return this;
    }

    /**
     * Get the microsoftPeeringConfig property: The Microsoft peering configuration.
     *
     * @return the microsoftPeeringConfig value.
     */
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().microsoftPeeringConfig();
    }

    /**
     * Set the microsoftPeeringConfig property: The Microsoft peering configuration.
     *
     * @param microsoftPeeringConfig the microsoftPeeringConfig value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withMicrosoftPeeringConfig(
        ExpressRouteCircuitPeeringConfig microsoftPeeringConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withMicrosoftPeeringConfig(microsoftPeeringConfig);
        return this;
    }

    /**
     * Get the stats property: The peering stats of express route circuit.
     *
     * @return the stats value.
     */
    public ExpressRouteCircuitStatsInner stats() {
        return this.innerProperties() == null ? null : this.innerProperties().stats();
    }

    /**
     * Set the stats property: The peering stats of express route circuit.
     *
     * @param stats the stats value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withStats(ExpressRouteCircuitStatsInner stats) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withStats(stats);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the express route circuit peering resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the gatewayManagerEtag property: The GatewayManager Etag.
     *
     * @return the gatewayManagerEtag value.
     */
    public String gatewayManagerEtag() {
        return this.innerProperties() == null ? null : this.innerProperties().gatewayManagerEtag();
    }

    /**
     * Set the gatewayManagerEtag property: The GatewayManager Etag.
     *
     * @param gatewayManagerEtag the gatewayManagerEtag value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withGatewayManagerEtag(String gatewayManagerEtag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withGatewayManagerEtag(gatewayManagerEtag);
        return this;
    }

    /**
     * Get the lastModifiedBy property: Who was the last to modify the peering.
     *
     * @return the lastModifiedBy value.
     */
    public String lastModifiedBy() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedBy();
    }

    /**
     * Get the routeFilter property: The reference to the RouteFilter resource.
     *
     * @return the routeFilter value.
     */
    public SubResource routeFilter() {
        return this.innerProperties() == null ? null : this.innerProperties().routeFilter();
    }

    /**
     * Set the routeFilter property: The reference to the RouteFilter resource.
     *
     * @param routeFilter the routeFilter value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withRouteFilter(SubResource routeFilter) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withRouteFilter(routeFilter);
        return this;
    }

    /**
     * Get the ipv6PeeringConfig property: The IPv6 peering configuration.
     *
     * @return the ipv6PeeringConfig value.
     */
    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().ipv6PeeringConfig();
    }

    /**
     * Set the ipv6PeeringConfig property: The IPv6 peering configuration.
     *
     * @param ipv6PeeringConfig the ipv6PeeringConfig value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withIpv6PeeringConfig(
        Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withIpv6PeeringConfig(ipv6PeeringConfig);
        return this;
    }

    /**
     * Get the expressRouteConnection property: The ExpressRoute connection.
     *
     * @return the expressRouteConnection value.
     */
    public ExpressRouteConnectionId expressRouteConnection() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteConnection();
    }

    /**
     * Set the expressRouteConnection property: The ExpressRoute connection.
     *
     * @param expressRouteConnection the expressRouteConnection value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withExpressRouteConnection(ExpressRouteConnectionId expressRouteConnection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withExpressRouteConnection(expressRouteConnection);
        return this;
    }

    /**
     * Get the connections property: The list of circuit connections associated with Azure Private Peering for this
     * circuit.
     *
     * @return the connections value.
     */
    public List<ExpressRouteCircuitConnectionInner> connections() {
        return this.innerProperties() == null ? null : this.innerProperties().connections();
    }

    /**
     * Set the connections property: The list of circuit connections associated with Azure Private Peering for this
     * circuit.
     *
     * @param connections the connections value to set.
     * @return the ExpressRouteCircuitPeeringInner object itself.
     */
    public ExpressRouteCircuitPeeringInner withConnections(List<ExpressRouteCircuitConnectionInner> connections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteCircuitPeeringPropertiesFormatInner();
        }
        this.innerProperties().withConnections(connections);
        return this;
    }

    /**
     * Get the peeredConnections property: The list of peered circuit connections associated with Azure Private Peering
     * for this circuit.
     *
     * @return the peeredConnections value.
     */
    public List<PeerExpressRouteCircuitConnectionInner> peeredConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().peeredConnections();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
