// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ConnectionMonitorDestination;
import com.azure.resourcemanager.network.models.ConnectionMonitorEndpoint;
import com.azure.resourcemanager.network.models.ConnectionMonitorOutput;
import com.azure.resourcemanager.network.models.ConnectionMonitorSource;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestConfiguration;
import com.azure.resourcemanager.network.models.ConnectionMonitorTestGroup;
import com.azure.resourcemanager.network.models.ConnectionMonitorType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Describes the properties of a connection monitor. */
@Fluent
public final class ConnectionMonitorResultProperties extends ConnectionMonitorParameters {
    /*
     * The provisioning state of the connection monitor.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The date and time when the connection monitor was started.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * The monitoring status of the connection monitor.
     */
    @JsonProperty(value = "monitoringStatus", access = JsonProperty.Access.WRITE_ONLY)
    private String monitoringStatus;

    /*
     * Type of connection monitor.
     */
    @JsonProperty(value = "connectionMonitorType", access = JsonProperty.Access.WRITE_ONLY)
    private ConnectionMonitorType connectionMonitorType;

    /** Creates an instance of ConnectionMonitorResultProperties class. */
    public ConnectionMonitorResultProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the connection monitor.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the startTime property: The date and time when the connection monitor was started.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the monitoringStatus property: The monitoring status of the connection monitor.
     *
     * @return the monitoringStatus value.
     */
    public String monitoringStatus() {
        return this.monitoringStatus;
    }

    /**
     * Get the connectionMonitorType property: Type of connection monitor.
     *
     * @return the connectionMonitorType value.
     */
    public ConnectionMonitorType connectionMonitorType() {
        return this.connectionMonitorType;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withSource(ConnectionMonitorSource source) {
        super.withSource(source);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withDestination(ConnectionMonitorDestination destination) {
        super.withDestination(destination);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withAutoStart(Boolean autoStart) {
        super.withAutoStart(autoStart);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withMonitoringIntervalInSeconds(Integer monitoringIntervalInSeconds) {
        super.withMonitoringIntervalInSeconds(monitoringIntervalInSeconds);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withEndpoints(List<ConnectionMonitorEndpoint> endpoints) {
        super.withEndpoints(endpoints);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withTestConfigurations(
        List<ConnectionMonitorTestConfiguration> testConfigurations) {
        super.withTestConfigurations(testConfigurations);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withTestGroups(List<ConnectionMonitorTestGroup> testGroups) {
        super.withTestGroups(testGroups);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withOutputs(List<ConnectionMonitorOutput> outputs) {
        super.withOutputs(outputs);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ConnectionMonitorResultProperties withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
