/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.models.IsolationScope;
import java.io.IOException;
import java.util.UUID;

public final class UserAssignedIdentityProperties
implements JsonSerializable<UserAssignedIdentityProperties> {
    private UUID tenantId;
    private UUID principalId;
    private UUID clientId;
    private IsolationScope isolationScope;

    public UUID tenantId() {
        return this.tenantId;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public UUID clientId() {
        return this.clientId;
    }

    public IsolationScope isolationScope() {
        return this.isolationScope;
    }

    public UserAssignedIdentityProperties withIsolationScope(IsolationScope isolationScope) {
        this.isolationScope = isolationScope;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("isolationScope", this.isolationScope == null ? null : this.isolationScope.toString());
        return jsonWriter.writeEndObject();
    }

    public static UserAssignedIdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserAssignedIdentityProperties)jsonReader.readObject(reader -> {
            UserAssignedIdentityProperties deserializedUserAssignedIdentityProperties = new UserAssignedIdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.principalId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.clientId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("isolationScope".equals(fieldName)) {
                    deserializedUserAssignedIdentityProperties.isolationScope = IsolationScope.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserAssignedIdentityProperties;
        });
    }
}

