/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ActivityLogAlertActionGroup
implements JsonSerializable<ActivityLogAlertActionGroup> {
    private String actionGroupId;
    private Map<String, String> webhookProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ActivityLogAlertActionGroup.class);

    public String actionGroupId() {
        return this.actionGroupId;
    }

    public ActivityLogAlertActionGroup withActionGroupId(String actionGroupId) {
        this.actionGroupId = actionGroupId;
        return this;
    }

    public Map<String, String> webhookProperties() {
        return this.webhookProperties;
    }

    public ActivityLogAlertActionGroup withWebhookProperties(Map<String, String> webhookProperties) {
        this.webhookProperties = webhookProperties;
        return this;
    }

    public void validate() {
        if (this.actionGroupId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actionGroupId in model ActivityLogAlertActionGroup"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionGroupId", this.actionGroupId);
        jsonWriter.writeMapField("webhookProperties", this.webhookProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ActivityLogAlertActionGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ActivityLogAlertActionGroup)jsonReader.readObject(reader -> {
            ActivityLogAlertActionGroup deserializedActivityLogAlertActionGroup = new ActivityLogAlertActionGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionGroupId".equals(fieldName)) {
                    deserializedActivityLogAlertActionGroup.actionGroupId = reader.getString();
                    continue;
                }
                if ("webhookProperties".equals(fieldName)) {
                    Map webhookProperties;
                    deserializedActivityLogAlertActionGroup.webhookProperties = webhookProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActivityLogAlertActionGroup;
        });
    }
}

