/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.monitor.fluent.PrivateLinkScopeOperationStatusClient;
import com.azure.resourcemanager.monitor.fluent.models.OperationStatusInner;
import com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import reactor.core.publisher.Mono;

public final class PrivateLinkScopeOperationStatusClientImpl
implements InnerSupportsGet<OperationStatusInner>,
PrivateLinkScopeOperationStatusClient {
    private final PrivateLinkScopeOperationStatusService service;
    private final MonitorClientImpl client;

    PrivateLinkScopeOperationStatusClientImpl(MonitorClientImpl client) {
        this.service = (PrivateLinkScopeOperationStatusService)RestProxy.create(PrivateLinkScopeOperationStatusService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OperationStatusInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String asyncOperationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (asyncOperationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter asyncOperationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, asyncOperationId, "2021-07-01-preview", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OperationStatusInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String asyncOperationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (asyncOperationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter asyncOperationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-07-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, asyncOperationId, "2021-07-01-preview", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationStatusInner> getByResourceGroupAsync(String resourceGroupName, String asyncOperationId) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, asyncOperationId).flatMap(res -> Mono.justOrEmpty((Object)((OperationStatusInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationStatusInner> getByResourceGroupWithResponse(String resourceGroupName, String asyncOperationId, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, asyncOperationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusInner getByResourceGroup(String resourceGroupName, String asyncOperationId) {
        return (OperationStatusInner)this.getByResourceGroupWithResponse(resourceGroupName, asyncOperationId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientPrivate")
    public static interface PrivateLinkScopeOperationStatusService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/privateLinkScopeOperationStatuses/{asyncOperationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationStatusInner>> getByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="asyncOperationId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

