// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.eventhubs.models;

/**
 * Type of Azure Active Directory Managed Identity.
 */
public enum CaptureIdentityType {
    /**
     * Enum value SystemAssigned.
     */
    SYSTEM_ASSIGNED("SystemAssigned"),

    /**
     * Enum value UserAssigned.
     */
    USER_ASSIGNED("UserAssigned");

    /**
     * The actual serialized value for a CaptureIdentityType instance.
     */
    private final String value;

    CaptureIdentityType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CaptureIdentityType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CaptureIdentityType object, or null if unable to parse.
     */
    public static CaptureIdentityType fromString(String value) {
        if (value == null) {
            return null;
        }
        CaptureIdentityType[] items = CaptureIdentityType.values();
        for (CaptureIdentityType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
