/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.models.Destination;
import com.azure.resourcemanager.eventhubs.models.EncodingCaptureDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class CaptureDescription {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CaptureDescription.class);
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="encoding")
    private EncodingCaptureDescription encoding;
    @JsonProperty(value="intervalInSeconds")
    private Integer intervalInSeconds;
    @JsonProperty(value="sizeLimitInBytes")
    private Integer sizeLimitInBytes;
    @JsonProperty(value="destination")
    private Destination destination;
    @JsonProperty(value="skipEmptyArchives")
    private Boolean skipEmptyArchives;

    public Boolean enabled() {
        return this.enabled;
    }

    public CaptureDescription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public EncodingCaptureDescription encoding() {
        return this.encoding;
    }

    public CaptureDescription withEncoding(EncodingCaptureDescription encoding) {
        this.encoding = encoding;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public CaptureDescription withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public Integer sizeLimitInBytes() {
        return this.sizeLimitInBytes;
    }

    public CaptureDescription withSizeLimitInBytes(Integer sizeLimitInBytes) {
        this.sizeLimitInBytes = sizeLimitInBytes;
        return this;
    }

    public Destination destination() {
        return this.destination;
    }

    public CaptureDescription withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public Boolean skipEmptyArchives() {
        return this.skipEmptyArchives;
    }

    public CaptureDescription withSkipEmptyArchives(Boolean skipEmptyArchives) {
        this.skipEmptyArchives = skipEmptyArchives;
        return this;
    }

    public void validate() {
        if (this.destination() != null) {
            this.destination().validate();
        }
    }
}

