/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dns.DnsZoneManager;
import com.azure.resourcemanager.dns.fluent.DnsManagementClient;
import com.azure.resourcemanager.dns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.dns.implementation.DnsRecordSetsBaseImpl;
import com.azure.resourcemanager.dns.implementation.DnsZoneImpl;
import com.azure.resourcemanager.dns.implementation.TxtRecordSetImpl;
import com.azure.resourcemanager.dns.models.RecordType;
import com.azure.resourcemanager.dns.models.TxtRecordSet;
import com.azure.resourcemanager.dns.models.TxtRecordSets;
import reactor.core.publisher.Mono;

class TxtRecordSetsImpl
extends DnsRecordSetsBaseImpl<TxtRecordSet, TxtRecordSetImpl>
implements TxtRecordSets {
    TxtRecordSetsImpl(DnsZoneImpl dnsZone) {
        super(dnsZone, RecordType.TXT);
    }

    public TxtRecordSet getByName(String name) {
        return (TxtRecordSet)this.getByNameAsync(name).block();
    }

    public Mono<TxtRecordSet> getByNameAsync(String name) {
        return ((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), name, this.recordType).map(this::wrapModel);
    }

    @Override
    protected PagedIterable<TxtRecordSet> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return super.wrapList(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByType(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType, pageSize, recordSetNameSuffix, Context.NONE));
    }

    @Override
    protected PagedFlux<TxtRecordSet> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((DnsManagementClient)((DnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.dnsZone.resourceGroupName(), this.dnsZone.name(), this.recordType));
    }

    protected TxtRecordSetImpl wrapModel(RecordSetInner inner) {
        if (inner == null) {
            return null;
        }
        return new TxtRecordSetImpl(inner.name(), this.dnsZone, inner);
    }
}

